/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ServicePackageDto;
import com.xforceplus.domain.resource.view.ServicePackageView;
import com.xforceplus.entity.App;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ServiceResourcesetRel;
import com.xforceplus.jpa.listener.ServicePackageListener;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="ServicePackage.graph", attributeNodes={@NamedAttributeNode(value="serviceResourcesetRels")})})
@EntityListeners(value={ServicePackageListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="bss_service_package")
public class ServicePackage
extends ServicePackageDto
implements Serializable {
    @JsonIgnore
    private List<ServiceResourcesetRel> serviceResourcesetRels;
    @JsonIgnore
    private List<CompanyServiceRel> companyServiceRels;
    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    private Set<Resourceset> resourcesets;
    @JsonIgnore
    private App app;

    public ServicePackage() {
    }

    public ServicePackage(Long servicePackageId, String servicePackageName, Long appId) {
        super(servicePackageId, servicePackageName, appId);
    }

    @Id
    @Column(name="service_package_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getServicePackageId() {
        return this.servicePackageId;
    }

    @Basic
    @Column(name="app_id")
    public Long getAppId() {
        return this.appId;
    }

    @Basic
    @Column(name="service_package_code")
    public String getServicePackageCode() {
        return this.servicePackageCode;
    }

    @Basic
    @Column(name="service_package_name")
    public String getServicePackageName() {
        return this.servicePackageName;
    }

    @Basic
    @Column(name="service_package_desc")
    public String getServicePackageDesc() {
        return this.servicePackageDesc;
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @ApiModelProperty(value="\u529f\u80fd\u96c6\u96c6\u5408")
    @Transient
    public Set<Resourceset> getResourcesets() {
        return this.resourcesets;
    }

    public void setResourcesets(Set<Resourceset> resourcesets) {
        this.resourcesets = resourcesets;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="servicePackage")
    public List<ServiceResourcesetRel> getServiceResourcesetRels() {
        return this.serviceResourcesetRels;
    }

    public void setServiceResourcesetRels(List<ServiceResourcesetRel> serviceResourcesetRels) {
        this.serviceResourcesetRels = serviceResourcesetRels;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="servicePackage")
    public List<CompanyServiceRel> getCompanyServiceRels() {
        return this.companyServiceRels;
    }

    public void setCompanyServiceRels(List<CompanyServiceRel> companyServiceRels) {
        this.companyServiceRels = companyServiceRels;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="app_id", referencedColumnName="app_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public App getApp() {
        return this.app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    @Transient
    public String getAppName() {
        if (this.app == null) {
            return null;
        }
        return this.app.getAppName();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

