/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.entity.OrgVirtualNode;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class OrgVirtualTreeQueryHelper {
    public static Specification<OrgVirtualNode> querySpecification(OrgVirtualNodeModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            predicates.add(builder.equal((Expression)root.get("nodeTypeId"), (Object)query.getTypeId()));
            if (null != query.getOrgVirtualId()) {
                predicates.add(builder.equal((Expression)root.get("orgVirtualId"), (Object)query.getOrgVirtualId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getParentIds())) {
                predicates.add(builder.like((Expression)root.get("parentIds"), query.getParentIds() + "%"));
            }
            Join joinUser = root.join("orgVirtual", JoinType.LEFT);
            if (StringUtils.isNotBlank((CharSequence)query.getOrgCode())) {
                predicates.add(builder.and(new Predicate[]{builder.like((Expression)joinUser.get("orgCode"), query.getOrgCode() + "%")}));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
                predicates.add(builder.and(new Predicate[]{builder.like((Expression)joinUser.get("orgName"), query.getOrgName() + "%")}));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

