/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.entity.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public class ResourceQueryHelper {
    public static Specification<Resource> querySpecification(ResourceModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            boolean isFlat;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getResourcesetId() != null && query.getResourcesetId() > 0L || query.getTenantId() != null && query.getTenantId() > 0L || query.getRoleId() != null && query.getRoleId() > 0L || query.getUserId() != null && query.getUserId() > 0L || !CollectionUtils.isEmpty((Collection)query.getPackageIds())) {
                Join joinResourceset = root.joinList("resourcesetResourceRels", JoinType.LEFT).join("resourceset", JoinType.LEFT);
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinResourceset.get("status"), (Object)1));
                }
                if (query.getResourcesetId() != null && query.getResourcesetId() > 0L) {
                    predicates.add(builder.equal((Expression)joinResourceset.get("resourcesetId"), (Object)query.getResourcesetId()));
                } else if (!CollectionUtils.isEmpty((Collection)query.getResourcesetIds())) {
                    predicates.add(joinResourceset.get("resourcesetId").in(query.getResourcesetIds()));
                }
                if (query.getTenantId() != null && query.getTenantId() > 0L || query.getCompanyId() != null && query.getCompanyId() > 0L || !CollectionUtils.isEmpty((Collection)query.getPackageIds())) {
                    ListJoin joinServiceResourcesetRel = joinResourceset.joinList("serviceResourcesetRels", JoinType.LEFT);
                    Join joinServicePackage = joinServiceResourcesetRel.join("servicePackage", JoinType.LEFT);
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinServicePackage.get("status"), (Object)1));
                    }
                    if (!CollectionUtils.isEmpty((Collection)query.getPackageIds())) {
                        predicates.add(joinServicePackage.get("servicePackageId").in(query.getPackageIds()));
                    }
                    ListJoin joinCompanyServiceRel = joinServicePackage.joinList("companyServiceRels", JoinType.LEFT);
                    if (query.getTenantId() != null && query.getTenantId() > 0L) {
                        predicates.add(builder.equal((Expression)joinCompanyServiceRel.get("tenantId"), (Object)query.getTenantId()));
                    }
                    if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                        predicates.add(builder.equal((Expression)joinCompanyServiceRel.get("companyId"), (Object)query.getCompanyId()));
                    }
                }
                if (query.getRoleId() != null && query.getRoleId() > 0L || query.getUserId() != null && query.getUserId() > 0L) {
                    ListJoin joinRoleResourcesetRels = joinResourceset.joinList("roleResourcesetRels", JoinType.LEFT);
                    if (query.getRoleId() != null && query.getRoleId() > 0L) {
                        predicates.add(builder.equal((Expression)joinRoleResourcesetRels.get("roleId"), (Object)query.getRoleId()));
                    }
                    if (query.getUserId() != null && query.getUserId() > 0L) {
                        Join joinRole = joinRoleResourcesetRels.join("role", JoinType.LEFT);
                        if (query.getStatus() != null && query.getStatus() == 1) {
                            predicates.add(builder.equal((Expression)joinRole.get("status"), (Object)1));
                        }
                        ListJoin joinRoleUserRels = joinRole.joinList("roleUserRels", JoinType.LEFT);
                        predicates.add(builder.equal((Expression)joinRoleUserRels.get("userId"), (Object)query.getUserId()));
                    }
                }
                joinTable = true;
            }
            if (query.getServiceApiId() != null && query.getServiceApiId() > 0L || StringUtils.isNotBlank((CharSequence)query.getServiceApiName())) {
                ListJoin joinResourceApiRels = root.joinList("resourceApiRels", JoinType.LEFT);
                if (query.getServiceApiId() != null && query.getServiceApiId() > 0L) {
                    predicates.add(builder.equal((Expression)joinResourceApiRels.get("serviceApiId"), (Object)query.getServiceApiId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getServiceApiName())) {
                    Join joinServiceApi = joinResourceApiRels.join("serviceApi", JoinType.LEFT);
                    predicates.add(builder.like((Expression)joinServiceApi.get("serviceApiName"), query.getServiceApiName() + "%"));
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinServiceApi.get("status"), (Object)1));
                    }
                }
                joinTable = true;
            }
            if (query.getResourceId() != null && query.getResourceId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("resourceId"), (Object)query.getResourceId()));
            } else if (!CollectionUtils.isEmpty((Collection)query.getResourceIds())) {
                predicates.add(root.get("resourceId").in(query.getResourceIds()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getResourceName())) {
                predicates.add(builder.like((Expression)root.get("resourceName"), query.getResourceName() + "%"));
            }
            if (query.getAppId() != null && query.getAppId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                predicates.add(builder.equal((Expression)root.get("resourceCode"), (Object)query.getResourceCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getResourceCodeLike())) {
                predicates.add(builder.like((Expression)root.get("resourceCode"), query.getResourceCodeLike() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (query.getIsServicePackage() != null) {
                predicates.add(builder.equal((Expression)root.get("isServicePackage"), (Object)query.getIsServicePackage()));
            }
            if (isFlat = query.isFlat()) {
                if (query.getParentId() != null && query.getParentId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("parentId"), (Object)query.getParentId()));
                }
            } else {
                predicates.add(builder.or((Expression)builder.isNull((Expression)root.get("parentId")), (Expression)builder.equal((Expression)root.get("parentId"), (Object)0)));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("resourceId")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Resource> queryOneSpecification(ResourceModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getResourceId() != null && query.getResourceId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("resourceId"), (Object)query.getResourceId()));
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getResourceName())) {
                    predicates.add(builder.equal((Expression)root.get("resourceName"), (Object)query.getResourceName()));
                }
                if (query.getAppId() != null && query.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

