package com.xforceplus.dao;

import com.xforceplus.entity.Account;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface AccountDao extends JpaRepository<Account, Long>, JpaSpecificationExecutor<Account> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Account a where a.accountId = :accountId")
    void deleteById(@Param("accountId") Long id);

    @Override
    List<Account> findAll();

    @Query("select a from Account a where a.telPhone = :telPhone")
    Account findByTelPhone(@Param("telPhone") String telPhone);

    @Query("select a from Account a where a.email = :email")
    Account findByEmail(@Param("email") String email);

    @Query("select a from Account a where a.username = :username")
    Account findByUsername(@Param("username") String username);

    /**
     * 通过username 查找是否匹配 用户名， 邮箱，手机号
     * @param loginName
     * @return
     */
    @Query("select a from Account a where a.username = :loginName or a.email = :loginName or a.telPhone = :loginName")
    List<Account> findAllByLoginName(@Param("loginName") String loginName);
}
