package com.xforceplus.dao;

import com.xforceplus.entity.Client;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.PagingAndSortingRepository;


public interface ClientDao extends JpaRepository<Client, String>, PagingAndSortingRepository<Client, String>, JpaSpecificationExecutor<Client> {

    Client findByClientIdAndSecretAndStatus(String clientId, String secret, boolean status);

    /**
     * 根据ClientId查询数据
     * @param clientId  clientId
     * @return Client是否已存在
     */
    Client findByClientId(String clientId);

    /***
     * 根据ClientId删除数据
     * @param clientId ClientId
     * @return  int 影响行数
     */
    int deleteByClientId(String clientId);
}
