package com.xforceplus.dao;

import com.xforceplus.entity.CompanyApply;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface CompanyApplyDao extends JpaRepository<CompanyApply, Long>, JpaSpecificationExecutor<CompanyApply> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyApply ca where ca.companyApplyId = :companyApplyId")
    void deleteById(@Param("companyApplyId") Long id);

    @Override
    List<CompanyApply> findAll();

    List<CompanyApply> findByTaxNum(String taxNum);

    /**
     * 根据租户ID和税号查询是否申请
     * @param tenantId 租户ID
     * @param taxNum 税号
     * @return List<CompanyApply>
     */
    List<CompanyApply> findByTenantIdAndTaxNum(Long tenantId, String taxNum);
}
