package com.xforceplus.dao;

import com.xforceplus.entity.OrgCompanyRel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface OrgCompanynoDao extends JpaRepository<OrgCompanyRel, Long>, JpaSpecificationExecutor<OrgCompanyRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from OrgCompanyRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    //@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") })
    @Override
    List<OrgCompanyRel> findAll();

    @Query("select r from OrgCompanyRel r where r.orgStructId = :orgId")
    List<OrgCompanyRel> findByOrgId(@Param("orgId") long orgId);

    /**
     * 查询列表
     * @param orgIds
     * @return  List<OrgCompanyRel>
     */
    @Query(" select r from OrgCompanyRel r where r.orgStructId in(:orgIds) ")
    List<OrgCompanyRel> findByOrgIds(@Param("orgIds") List<Long> orgIds);


    @Modifying(clearAutomatically = true)
    @Query("delete from OrgCompanyRel r where r.orgStructId = :orgId")
    void deleteByOrgId(@Param("orgId") long orgId);
}
