package com.xforceplus.dao;

import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.bo.org.OrgUserStatisticsQueryBo;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.dto.org.OrgParentDTO;
import com.xforceplus.dto.org.OrgUserStatisticsDTO;
import org.springframework.data.repository.NoRepositoryBean;

import java.util.List;

/**
 * @Author: HWT
 * @Date: 2020/11/10 11:31
 */
@NoRepositoryBean
@SuppressWarnings("all")
public interface OrgExtendDao {

  /**
   * 查询该用户关联的 role 所分配的所有资源码信息
   *
   * @param userId userId
   * @return List<ResourceDTO>
   */
  List<OrgDto> getOrgByTenantCodeAndOrgCode(String tenantCode, String orgCode);

  /**
   * 根据税号查询
   *
   * @param queryBo 查询参数
   * @return List<OrgCompanyDTO>
   */
  List<OrgCompanyDTO> findOrgCompanyByTaxNum(OrgCompanyQueryBo queryBo);

  /**
   * 查询每个组织组织用户数据统计
   *
   * @param queryBo
   * @return List<OrgUserStatisticsDTO>
   */
  List<OrgUserStatisticsDTO> findUserStatisticsByOrgIds(OrgUserStatisticsQueryBo queryBo);

  /**
   * 查询父组组织信息
   *
   * @param orgIds 组织ID列表
   * @return List<OrgParentDTO> 父组组织信息
   */
  List<OrgParentDTO> findOrgParentByOrgIds(List<Long> orgIds);
}
