package com.xforceplus.dao;

import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.User;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;
import java.util.Set;


/**
 * 组织-用户-关系表 Dao
 * @author : geewit
 * Date: 19-12-03
 */
public interface OrgUserRelDao extends JpaRepository<OrgUserRel, Long>, JpaSpecificationExecutor<OrgUserRel> {
    @Transactional
    @Override
    OrgUserRel saveAndFlush(OrgUserRel entity);

    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Query("select rel.org from OrgUserRel rel where rel.userId = :userId")
    List<OrgStruct> findOrgsByUserId(@Param("userId") long userId);


    @Query("select rel.user from OrgUserRel rel where rel.orgStructId = :orgId")
    Page<User> findByOrgId(@Param("orgId") long orgId, Pageable pageable);


    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.userId = :userId and rel.orgStructId = :orgId")
    void deleteByUserIdAndOrgId(@Param("userId") long userId, @Param("orgId") long orgId);

    @Query("select rel from OrgUserRel rel where rel.userId = :userId")
    List<OrgUserRel> findByUserId(@Param("userId") long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.orgStructId = :orgId")
    void deleteByTenantIdAndUserIdAndOrgId(@Param("tenantId") long tenantId, @Param("userId") long userId, @Param("orgId") Long orgId);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.userId = :userId")
    void deleteByUserId(@Param("userId") long userId);

    @Query("select rel.orgStructId from OrgUserRel rel where rel.userId = :userId")
    List<Long> findOrgIdsByUserId(@Param("userId") long userId);

    @Query("select rel.userId from OrgUserRel rel where rel.orgStructId = :orgId")
    Set<Long> findUserIdsByOrgId(@Param("orgId") long orgId);

    List<OrgUserRel> findByTenantId(Long tenantId);

    @Query(value = "SELECT rel.user_id FROM sys_org_user_rel rel LEFT join sys_org_struct o on o.org_struct_id = rel.org_struct_id WHERE o.parent_ids like :parentIds", nativeQuery = true)
    Set<Long> findUserIdsByParentIdsLike(@Param("parentIds") String parentIds);

    @Query("select rel.userId from OrgUserRel rel where rel.orgStructId in(:orgIds) ")
    Set<Long> findUserIdsByOrgIds(@Param("orgIds") Collection<Long> parentOrgIds);

    @EntityGraph(value = "OrgUserRel.graph", type = EntityGraph.EntityGraphType.FETCH)
    @Query("select rel from OrgUserRel rel where rel.orgStructId in(:orgIds) ")
    Set<OrgUserRel> findRelsByOrgIds(@Param("orgIds") Collection<Long> parentOrgIds);

    @Modifying(flushAutomatically = true)
    @Query("update OrgUserRel rel set rel.tenantId = :tenantId where rel.id in (:orgUserRelIds)")
    void batchUpdateTenant(@Param("orgUserRelIds") List<Long> roleUserRelIds, @Param("tenantId")Long tenantId);
}