package com.xforceplus.dao;

import com.xforceplus.entity.OrgVirtualNode;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;
import java.util.Optional;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
public interface OrgVirtualNodeDao extends JpaRepository<OrgVirtualNode, Long>, JpaSpecificationExecutor<OrgVirtualNode>, CustomizedOrgVirtualNodeDao {


    List<OrgVirtualNode> findByTenantIdAndOrgVirtualId(Long tenantId, Long orgVirtualId);

    List<OrgVirtualNode> findByTenantIdAndParentId(Long tenantId, Long parentId);

    Optional<OrgVirtualNode> findByTenantIdAndNodeTypeIdAndParentIdIsNull(Long tenantId, Long typeId);

    Optional<OrgVirtualNode> findByTenantIdAndOrgVirtualNodeId(Long tenantId, Long orgVirtualNodeId);
}
