/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceSetExtendDao.java   2020-10-20 16-46-58
 * Author: Evan
 */
package com.xforceplus.dao;

import com.xforceplus.bo.ServicePackageQueryBo;
import com.xforceplus.dto.resource.ServicePackageDTO;
import com.xforceplus.dto.resource.ServicePackageResourceSetDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.NoRepositoryBean;

/**
 * <p>
 * Title:   ServicePackageExtendDao
 * </p>
 * <p>
 * Description: ServicePackageExtendDao扩展查询
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-20 16-46-58
 * @since V1.0
 */
@NoRepositoryBean
public interface ServicePackageExtendDao {

    /***
     *  分页查询以功集
     * @param pageable 分页对象
     * @param queryBo 查询条件
     * @return Page<ServicePackageResourceSetDTO>
     */
    Page<ServicePackageResourceSetDTO> pagingByResourceSet(Pageable pageable, ServicePackageQueryBo queryBo);

    /**
     *  产品服务包查询
     * @param pageable 分页对象
     * @param queryBo 查询条件
     * @return  Page<ServicePackageDTO>
     */
    Page<ServicePackageDTO> pagingBy(Pageable pageable, ServicePackageQueryBo queryBo);
}
