package com.xforceplus.dao;

import com.xforceplus.entity.SettleFlowTemplateRel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleFlowTemplateRelDao extends JpaRepository<SettleFlowTemplateRel, Long>, JpaSpecificationExecutor<SettleFlowTemplateRel> {

    @Query("select rel from SettleFlowTemplateRel rel where rel.flowId = :flowId and rel.templateId = :templateId")
    SettleFlowTemplateRel findAndByFlowIdAndTemplateId(@Param("flowId") long flowId, @Param("templateId") Long templateId);

    @Modifying(clearAutomatically = true)
    @Query("delete from SettleFlowTemplateRel rel where rel.flowId = :flowId")
    void deleteByFlowId(@Param("flowId") long flowId);
}
