package com.xforceplus.dao;

import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantCompanyRel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface TenantCompanyRelDao extends JpaRepository<TenantCompanyRel, Long>, JpaSpecificationExecutor<TenantCompanyRel> {
    /**
     * 查询所有关系功能信息
      * @return
     */
    @SuppressWarnings("all")
    @Query(value = "select bt.tenant_code as tenantCode, bt.tenant_name as tenantName, tcr.company_id as companyId from bss_tenant_company_rel tcr INNER JOIN bss_tenant bt on bt.tenant_id = tcr.tenant_id", nativeQuery = true)
    List<Object[]> findTenantCommpanyRelAll();

    @Query("select o.tenant from TenantCompanyRel o where o.companyId = :companyId")
    List<Tenant> findTenantsByCompanyId(@Param("companyId") Long companyId);

    List<TenantCompanyRel> findByCompanyId(Long companyId);
}
