package com.xforceplus.dao;

import com.xforceplus.entity.User;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;

import java.util.Collection;
import java.util.List;
import java.util.Optional;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface UserDao extends JpaRepository<User, Long>, JpaSpecificationExecutor<User> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from User u where u.id = :userId")
    void deleteById(@Param("userId") Long id);

    @Override
    @EntityGraph(value = "User.graph", type = EntityGraph.EntityGraphType.FETCH)
    Optional<User> findById(Long id);

    //@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") })
    //Iterable<User> findAll();
    @EntityGraph(value = "User.graph", type = EntityGraph.EntityGraphType.FETCH)
    @Query("select u from User u where u.accountId = :accountId and u.tenantId = :tenantId")
    List<User> findByAccountIdAndTenantId(@Param("accountId") long accountId, @Param("tenantId") long tenantId);

    Optional<User> findByTenantIdAndUserCode(long tenantId, String userCode);

    @Query("select u from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    List<User> findAllByTenantIdAndUserCode(@Param("tenantId") long tenantId, @Param("userCode") String userCode);

    @EntityGraph(value = "User.tenant.graph", type = EntityGraph.EntityGraphType.FETCH)
    List<User> findByAccountId(Long accountId);

    User findFirstByTenantIdAndAccountId(Long tenantId, Long accountId);

    @Query("select u.id from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    Long findIdByTenantIdAndCode(@Param("tenantId") long tenantId, @Param("userCode") String userCode);

    @Query("select u.id from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    List<Long> findListByTenantIdAndUserCode(@Param("tenantId") Long tenantId, @Param("userCode") String userCode);

    @EntityGraph(value = "User.graph", type = EntityGraph.EntityGraphType.FETCH)
    @Query("select u from User u where u.tenantId = :tenantId and u.id = :userId")
    Optional<User> findByTenantIdAndUserId(@Param("tenantId") long tenantId, @Param("userId") long userId);

    List<User> findByTenantId(Long tenantId);

    @Modifying(flushAutomatically = true)
    @Query("update User u set u.tenantId = :tenantId where u.id in (:userIds)")
    void batchUpdateTenant(@Param("userIds") List<Long> userIds, @Param("tenantId")Long tenantId);

    List<User> findByAccountIdIn(Collection<Long> accountIds);
}
