/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: TenantUserExtendDao.java   2020-12-29 09-12-11
 * Author: Evan
 */
package com.xforceplus.dao.user;

import com.xforceplus.bo.user.TenantUserBo;
import com.xforceplus.dto.user.TenantAdminUserDTO;
import com.xforceplus.dto.user.TenantUserDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * Title: 租户用户查询
 * </p>
 * <p>
 * Description: 租户用户查询
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-29 09-12-11
 * @since V1.0
 */
public interface TenantUserExtendDao {

    /**
     * 根据根据租户ID和角色ID查询租户管理员列表
     * @param tenantId 租户ID
     * @param roleId   角色ID
     * @return List<TenantAdminUserDTO>
     */
    List<TenantAdminUserDTO> findTenantAdminUserByTenantId(Long tenantId, Long roleId);

    /**
     * 根据租户ID及用户状态、用户类型查询相关信息
     *
     * @param pageable 分页对象
     * @param tenantUserBo 查询对象
     * @return  Page<TenantUserDTO>
     */
    Page<TenantUserDTO> findTenantUsersByTenantId(Pageable pageable, TenantUserBo tenantUserBo);

    /**
     *根据根据租户IDS和角色ID查询租户管理员列表（即返回200个租户管理员）
     * @param tenantIds  租户ID集合
     * @param roleId 角色ID
     * @return  List<TenantAdminUserDTO>
     */
    List<TenantAdminUserDTO> findTenantAdminUserByTenantIds(Set<Long> tenantIds, Long roleId);

    /**
     *  根据租户ID及用户状态、用户类型查询相关信息
     * @param pageable 分页对象
     * @param tenantUserBo 查询对象
     * @return Page<TenantUserDTO>
     */
    Page<TenantUserDTO> findTenantUsersByCondition(Pageable pageable, TenantUserBo tenantUserBo);
}
