package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.jpa.listener.OrgListener;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import io.geewit.core.jackson.view.View;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;


/**
 * 组织机构
 *
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = "Org.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("company"),
                        @NamedAttributeNode("tenant"),
                        @NamedAttributeNode("companyNos")
                }
        )})
@EntityListeners({OrgListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_struct")
public class OrgStruct extends OrgDto<OrgStruct, OrgExtension> implements Serializable {
    /**
     * 是否已经执行过 buildParentIds()
     */
    @JsonIgnore
    public boolean builtParentIds;
    @JsonView(OrgView.OrgInfo.class)
    private Company company;
    @JsonView(OrgView.OrgInfo.class)
    private Tenant tenant;
    @JsonView(OrgView.OrgInfo.class)
    private List<ServicePackage> packages;
    @JsonIgnore
    private List<OrgUserRel> orgUserRels;
    @JsonIgnore
    private List<OrgCompanyRel> orgCompanyRels;

    @Override
    @Id
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgId() {
        return orgId;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return (tenantId != null && tenantId > 0) ? tenantId : null;
    }

    @Override
    @Basic
    @Column(name = "company_id")
    public Long getCompanyId() {
        return (companyId != null && companyId > 0) ? companyId : null;
    }


    @Override
    @Basic
    @Column(name = "org_code", nullable = false)
    public String getOrgCode() {
        return orgCode;
    }


    @Override
    @Basic
    @Column(name = "org_name", nullable = false)
    public String getOrgName() {
        return orgName;
    }

    @Override
    @Basic
    @Column(name = "parent_ids", nullable = false)
    public String getParentIds() {
        return parentIds;
    }

    @Override
    @Basic
    @Column(name = "parent_id")
    public Long getParentId() {
        return (parentId != null && parentId > 0) ? parentId : null;
    }

    @Override
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "org_type", nullable = false)
    public OrgType getOrgType() {
        return orgType;
    }

    @Override
    @Basic
    @Column(name = "org_desc", nullable = false)
    public String getOrgDesc() {
        return orgDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "audit_status")
    public Integer getAuditStatus() {
        return auditStatus;
    }

    @Override
    @Basic
    @Column(name = "enabled_time")
    public Date getEnabledTime() {
        return enabledTime;
    }

    @Override
    @Basic
    @Column(name = "disabled_time")
    public Date getDisabledTime() {
        return disabledTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }


    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @JsonIgnore
    @Transient
    public List<OrgStruct> getChildren() {
        return super.children;
    }

    @JsonView(OrgView.OrgInfo.class)
    @Override
    @ElementCollection(fetch = FetchType.LAZY)
    @CollectionTable(name = "sys_org_companyno", joinColumns = @JoinColumn(name = "org_struct_id"))
    @Column(name = "company_no", insertable = false, updatable = false)
    public Set<String> getCompanyNos() {
        return super.companyNos;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", referencedColumnName = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "company_id", referencedColumnName = "company_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @NotFound(action = NotFoundAction.IGNORE)
    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getCompanyName() {
        if (super.companyName == null) {
            super.companyName = this.company != null ? this.company.getCompanyName() : null;
        }
        return super.companyName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getParentName() {
        return super.parentName;
    }


    @JsonView(View.List.class)
    @Transient
    @Override
    public String getCompanyCode() {
        if (super.companyCode == null) {
            super.companyCode = this.company != null ? this.company.getCompanyCode() : null;
        }
        return super.companyCode;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getTaxNum() {
        if (super.taxNum == null) {
            super.taxNum = this.company != null ? this.company.getTaxNum() : null;
        }
        return super.taxNum;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantName() {
        if (super.tenantName == null) {
            super.tenantName = this.tenant != null ? this.tenant.getTenantName() : null;
        }
        return super.tenantName;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantCode() {
        if (super.tenantCode == null) {
            super.tenantCode = this.tenant != null ? this.tenant.getTenantCode() : null;
        }
        return super.tenantCode;
    }

    @JsonView(OrgView.Info.class)
    @Transient
    public List<ServicePackage> getPackages() {
        return packages;
    }

    public void setPackages(List<ServicePackage> packages) {
        this.packages = packages;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "org")
    public List<OrgUserRel> getOrgUserRels() {
        return orgUserRels;
    }

    public void setOrgUserRels(List<OrgUserRel> orgUserRels) {
        this.orgUserRels = orgUserRels;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "org")
    public List<OrgCompanyRel> getOrgCompanyRels() {
        return orgCompanyRels;
    }

    public void setOrgCompanyRels(List<OrgCompanyRel> orgCompanyRels) {
        this.orgCompanyRels = orgCompanyRels;
    }

    @Override
    @JsonView(View.class)
    @Transient
    public List<OrgStruct> getParentOrgs() {
        return super.parentOrgs;
    }

    public void addChild(OrgStruct child) {
        if (this.children == null) {
            this.children = Stream.of(child).collect(Collectors.toList());
        } else {
            if (children.stream().filter(Objects::nonNull).map(OrgStruct::getOrgId).filter(Objects::nonNull).noneMatch(orgId -> orgId.equals(child.getOrgId()))) {
                this.children.add(child);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
