package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xforceplus.domain.orgVirtual.OrgVirtualDTO;
import com.xforceplus.jpa.listener.OrgVirtualListener;
import com.xforceplus.jpa.listener.RoleListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_virtual")
@EntityListeners({OrgVirtualListener.class})
public class OrgVirtual extends OrgVirtualDTO implements Serializable {


    private List<OrgVirtualNode> orgVirtualNodes;

    @Override
    @Id
    @Column(name = "org_virtual_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getOrgVirtualId() {
        return orgVirtualId;
    }

    @Override
    @Column(name = "org_struct_id")
    public Long getOrgStructId() {
        return orgStructId;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }


    @Override
    @Basic
    @Column(name = "org_code")
    public String getOrgCode() {
        return orgCode;
    }


    @Override
    @Basic
    @Column(name = "org_name")
    public String getOrgName() {
        return orgName;
    }


    @Override
    @Basic
    @Column(name = "short_name")
    public String getShortName() {
        return shortName;
    }


    @Override
    @Basic
    @Column(name = "org_desc")
    public String getOrgDesc() {
        return orgDesc;
    }


    @Override
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }


    @OneToMany(fetch = FetchType.LAZY, mappedBy = "orgVirtual")
    @JsonIgnore
    public List<OrgVirtualNode> getOrgVirtualNodes() {
        return orgVirtualNodes;
    }

    public void setOrgVirtualNodes(List<OrgVirtualNode> orgVirtualNodes) {
        this.orgVirtualNodes = orgVirtualNodes;
    }
}
