package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.jpa.listener.ResourcesetListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SuppressWarnings("all")
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({ResourcesetListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_resourceset")
public class Resourceset extends ResourcesetDto implements Serializable {

    @JsonIgnore
    private List<RoleResourcesetRel> roleResourcesetRels;

    @JsonIgnore
    private List<ResourcesetResourceRel> resourcesetResourceRels;

    @JsonIgnore
    private List<ServiceResourcesetRel> serviceResourcesetRels;

    @JsonView(View.Info.class)
    private Set<Resource> resources;

    @Override
    @Id
    @Column(name = "resourceset_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getResourcesetId() {
        return resourcesetId;
    }

    @Override
    @Basic
    @Column(name = "app_id", nullable = false)
    public Long getAppId() {
        return (appId != null ) ? appId : null;
    }

    @Override
    @Basic
    @Column(name = "resourceset_code")
    public String getResourcesetCode() {
        return resourcesetCode;
    }

    @Override
    @Basic
    @Column(name = "resourceset_name", nullable = false)
    public String getResourcesetName() {
        return resourcesetName;
    }

    @Override
    @Basic
    @Column(name = "resourceset_desc")
    public String getResourcesetDesc() {
        return resourcesetDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Basic
    @Column(name = "resource_id")
    public Long getResourceId() {
        return resourceId;
    }

    @Override
    @Basic
    @Column(name = "role_id")
    public Long getRoleId() {
        return roleId;
    }

    @JsonView(View.Info.class)
    @Transient
    public Set<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "resourceset")
    public List<RoleResourcesetRel> getRoleResourcesetRels() {
        return roleResourcesetRels;
    }

    public void setRoleResourcesetRels(List<RoleResourcesetRel> roleResourcesetRels) {
        this.roleResourcesetRels = roleResourcesetRels;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "resourceset")
    public List<ResourcesetResourceRel> getResourcesetResourceRels() {
        return resourcesetResourceRels;
    }

    public void setResourcesetResourceRels(List<ResourcesetResourceRel> resourcesetResourceRels) {
        this.resourcesetResourceRels = resourcesetResourceRels;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "resourceset")
    public List<ServiceResourcesetRel> getServiceResourcesetRels() {
        return serviceResourcesetRels;
    }

    public void setServiceResourcesetRels(List<ServiceResourcesetRel> serviceResourcesetRels) {
        this.serviceResourcesetRels = serviceResourcesetRels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Resourceset that = (Resourceset) o;
        return Objects.equals(resourcesetId, that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetId);
    }

}
