package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.jpa.listener.RoleListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = "Role.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("roleResourcesetRels")
                }
        )})
@EntityListeners({RoleListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role")
public class Role extends RoleDto<Resourceset> implements Serializable {
    @JsonIgnore
    private List<RoleResourcesetRel> roleResourcesetRels;

    @JsonIgnore
    private List<RoleUserRel> roleUserRels;

    @Override
    @Id
    @Column(name = "role_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "role_code", nullable = false)
    public String getCode() {
        return code;
    }

    @Override
    @Basic
    @Column(name = "tenant_id", nullable = false, updatable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @Basic
    @Column(name = "role_name", nullable = false)
    public String getName() {
        return name;
    }

    @Override
    @Basic
    @Column(name = "role_desc", nullable = false)
    public String getRoleDesc() {
        return roleDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Basic
    @Column(name = "from_role_id")
    public Long getFromRoleId() {
        return fromRoleId;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleResourcesetRel> getRoleResourcesetRels() {
        return roleResourcesetRels;
    }

    public void setRoleResourcesetRels(List<RoleResourcesetRel> roleResourcesetRels) {
        this.roleResourcesetRels = roleResourcesetRels;
    }


    @OneToMany(fetch = FetchType.LAZY, mappedBy = "role")
    public List<RoleUserRel> getRoleUserRels() {
        return roleUserRels;
    }

    public void setRoleUserRels(List<RoleUserRel> roleUserRels) {
        this.roleUserRels = roleUserRels;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
