package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.resource.ServiceApiDto;
import com.xforceplus.jpa.listener.ServiceApiListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.*;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


@SuppressWarnings("all")
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = "ServiceApi.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("app")
                }
        )})
@EntityListeners({ServiceApiListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_service_api")
public class ServiceApi extends ServiceApiDto implements Serializable {

    @JsonIgnore
    private App app;

    @JsonIgnore
    private List<ResourceApiRel> resourceApiRels;

    @Override
    @Id
    @Column(name = "service_api_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getServiceApiId() {
        return serviceApiId;
    }

    @Override
    @Basic
    @Column(name = "service_api_path", nullable = false)
    public String getServiceApiPath() {
        return serviceApiPath;
    }

    @Override
    @Basic
    @Column(name = "service_api_url", nullable = false)
    public String getServiceApiUrl() {
        return serviceApiUrl;
    }

    @Override
    @Enumerated(EnumType.STRING)
    @Column(name = "request_method", nullable = false)
    public RequestMethod getRequestMethod() {
        return requestMethod;
    }

    @Override
    @Basic
    @Column(name = "app_id")
    public Long getAppId() {
        return (appId != null && appId > 0) ? appId : null;
    }

    @Override
    @Basic
    @Column(name = "route_id")
    public Long getRouteId() {
        return routeId;
    }

    @Override
    @Basic
    @Column(name = "skip_authentication")
    public Boolean getSkipAuthentication() {
        return skipAuthentication;
    }

    @Override
    @Basic
    @Column(name = "skip_authorization")
    public Boolean getSkipAuthorization() {
        return skipAuthorization;
    }

    @Override
    @Basic
    @Column(name = "service_api_name", nullable = false)
    public String getServiceApiName() {
        return serviceApiName;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "app_id", referencedColumnName = "app_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @NotFound(action = NotFoundAction.IGNORE)
    public App getApp() {
        return app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "serviceApi")
    public List<ResourceApiRel> getResourceApiRels() {
        return resourceApiRels;
    }

    public void setResourceApiRels(List<ResourceApiRel> resourceApiRels) {
        this.resourceApiRels = resourceApiRels;
    }

    @Override
    @Transient
    public String getAppName() {
        if (this.appName != null) {
            return this.appName;
        }
        if (this.app != null) {
            this.appName = this.app.getAppName();
            return this.appName;
        }
        return null;
    }
}
