package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "settle_flow_role_rel")
public class SettleFlowRoleRel implements Serializable {
    private Long id;

    private Long flowId;

    private Long roleId;

    private Integer status;

    private SettleFlow flow;
    private Role role;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Column(name = "flow_id")
    public Long getFlowId() {
        return (flowId != null && flowId > 0) ? flowId : null;
    }

    @Column(name = "role_id")
    public Long getRoleId() {
        return (roleId != null && roleId > 0) ? roleId : null;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flow_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
//    @NotFound(action = NotFoundAction.IGNORE)
    public SettleFlow getFlow() {
        return flow;
    }

    public void setFlow(SettleFlow flow) {
        this.flow = flow;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
//    @NotFound(action = NotFoundAction.IGNORE)
    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SettleFlowRoleRel that = (SettleFlowRoleRel) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(flowId, that.flowId) &&
                Objects.equals(roleId, that.roleId) &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, flowId, roleId, status);
    }
}
