package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.sso.SsoConfDto;
import com.xforceplus.domain.sso.SsoSamlDto;
import com.xforceplus.jpa.listener.SsoConfListener;
import com.xforceplus.jpa.listener.SsoSamlConfListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_sso_saml")
@EntityListeners({SsoSamlConfListener.class})
public class SsoSaml extends SsoSamlDto implements Serializable {

    private SsoConf ssoConf;

    @Override
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public long getId() {
        return id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @Basic
    @Column(name = "sso_id")
    public long getSsoId() {
        return ssoId;
    }

    @Override
    public void setSsoId(long ssoId) {
        this.ssoId = ssoId;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Basic
    @Column(name = "entity_id")
    public String getEntityId() {
        return entityId;
    }

    @Override
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Basic
    @Column(name = "meta_file_path")
    public String getMetaFilePath() {
        return metaFilePath;
    }

    @Override
    public void setMetaFilePath(String metaFilePath) {
        this.metaFilePath = metaFilePath;
    }

    @Override
    @Basic
    @Column(name = "sign_algorithm")
    public String getSignAlgorithm() {
        return signAlgorithm;
    }

    @Override
    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    @Override
    @Basic
    @Column(name = "sign_metadata")
    public boolean isSignMetadata() {
        return signMetadata;
    }

    @Override
    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    @Override
    @Basic
    @Column(name = "alias")
    public String getAlias() {
        return alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdateUserId() {
        return updateUserId;
    }

    @Override
    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdateUserName() {
        return updateUserName;
    }

    @Override
    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id")
    public String getCreateUserId() {
        return createUserId;
    }

    @Override
    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JoinColumn(name="sso_id",unique=true, insertable = false , updatable = false)
    @OneToOne
    @JsonIgnore
    public SsoConf getSsoConf() {
        return ssoConf;
    }

    public void setSsoConf(SsoConf ssoConf) {
        this.ssoConf = ssoConf;
    }
}
