package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.jpa.listener.UserListener;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings("all")
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({UserListener.class})
@NamedEntityGraphs({
        @NamedEntityGraph(name = "User.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("tenant"),
                        @NamedAttributeNode("account")
                }
        ),
        @NamedEntityGraph(name = "User.tenant.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("tenant")
                }
        )})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_user")
public class User extends UserDto<OrgStruct, Role, Account, OrgExtension> implements Serializable {

    @ApiModelProperty("租户信息")
    private Tenant tenant;

    @JsonIgnore
    private List<RoleUserRel> roleUserRels;

    @JsonIgnore
    private List<OrgVirtualNodeUserRel> orgVirtualNodeUserRels;

    @JsonIgnore
    private List<UserApp> userApps;

    @JsonIgnore
    private Set<Resource> roleResources;

    @JsonIgnore
    private Set<ServicePackage> packages;

    @JsonIgnore
    private Set<Resource> packageResources;

    @JsonIgnore
    private List<UserTag> userTags;

    @JsonIgnore
    private Map<Long, Set<String>> appResources;

    @ApiModelProperty(hidden = true)
    private Integer cachedExtraInfoDimension;

    @Override
    @Id
    @Column(name = "user_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Min(value = 1)
    @NotNull
    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @Min(value = 1)
    @NotNull
    @Basic
    @Column(name = "account_id", nullable = false)
    public Long getAccountId() {
        return accountId;
    }

    @Override
    @Basic
    @Column(name = "user_code")
    public String getUserCode() {
        return userCode;
    }

    @Override
    @Basic
    @Column(name = "user_number")
    public String getUserNumber() {
        return userNumber;
    }

    @Override
    @Basic
    @Column(name = "user_name")
    public String getUserName() {
        return userName;
    }

    @Override
    @Basic
    @Column(name = "user_phone")
    public String getUserPhone() {
        return userPhone;
    }

    @Override
    @Basic
    @Column(name = "user_sex")
    public Integer getUserSex() {
        return userSex;
    }

    @Override
    @Basic
    @Column(name = "user_email_addr")
    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    @Override
    @Basic
    @Column(name = "user_id_card")
    public String getUserIdCard() {
        return userIdCard;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "user_period_time")
    public Date getUserPeriodTime() {
        return userPeriodTime;
    }

    @Override
    @Basic
    @Column(name = "user_work_tel")
    public String getUserWorkTel() {
        return userWorkTel;
    }

    @Override
    @Basic
    @Column(name = "active_status")
    public Integer getActiveStatus() {
        return activeStatus;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "contact_addr")
    public String getContactAddr() {
        return contactAddr;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @JsonView(UserView.UserInfo.class)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @Override
    @JsonView(UserView.UserInfo.class)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "account_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Account getAccount() {
        return super.account;
    }

    @JsonIgnore
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "user")
    public List<RoleUserRel> getRoleUserRels() {
        return roleUserRels;
    }

    public void setRoleUserRels(List<RoleUserRel> roleUserRels) {
        this.roleUserRels = roleUserRels;
    }

    @JsonView(UserView.UserInfo.class)
    @Transient
    public Map<Long, Set<String>> getAppResources() {
        return appResources;
    }

    public void setAppResources(Map<Long, Set<String>> appResources) {
        this.appResources = appResources;
    }

    /**
     * 通过求交集获取最终资源码集合
     *
     * @return 最终资源码集合
     */
    @Override
    @JsonView(UserView.UserInfo.class)
    @Transient
    public Set<String> getResourceCodes() {
        return super.resourceCodes;
    }

    /**
     * 获取通过角色关联的资源码集合
     *
     * @return 通过角色关联的资源码集合
     */
    @JsonView(UserView.UserInfo.class)
    @Transient
    public Set<Resource> getRoleResources() {
        return roleResources;
    }

    public void setRoleResources(Set<Resource> roleResources) {
        this.roleResources = roleResources;
    }

    @JsonView(UserView.UserInfo.class)
    @Transient
    public Set<ServicePackage> getPackages() {
        return packages;
    }

    public void setPackages(Set<ServicePackage> packages) {
        this.packages = packages;
    }

    /**
     * 获取通过公司服务包关联的资源码集合
     *
     * @return 通过公司服务包关联的资源码集合
     */
    @JsonView(UserView.UserInfo.class)
    @Transient
    public Set<Resource> getPackageResources() {
        return packageResources;
    }

    public void setPackageResources(Set<Resource> packageResources) {
        this.packageResources = packageResources;
    }

    @JsonIgnore
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "user")
    public List<UserApp> getUserApps() {
        return userApps;
    }

    public void setUserApps(List<UserApp> userApps) {
        this.userApps = userApps;
    }


    @Override
    @JsonView({UserView.UserInfo.class, TokenView.class})
    @Transient
    public String getTenantName() {
        this.tenantName = this.tenant != null ? this.tenant.getTenantName() : null;
        return this.tenantName;
    }

    @Override
    @JsonView({UserView.UserInfo.class, TokenView.class})
    @Transient
    public String getTenantCode() {
        this.tenantCode = this.tenant != null ? this.tenant.getTenantCode() : null;
        return this.tenantCode;
    }

    @JsonIgnore
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "user")
    public List<UserTag> getUserTags() {
        return userTags;
    }

    public void setUserTags(List<UserTag> userTags) {
        this.userTags = userTags;
    }

    @Transient
    public Integer getCachedExtraInfoDimension() {
        return cachedExtraInfoDimension;
    }

    public void setCachedExtraInfoDimension(Integer cachedExtraInfoDimension) {
        this.cachedExtraInfoDimension = cachedExtraInfoDimension;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "user")
    public List<OrgVirtualNodeUserRel> getOrgVirtualNodeUserRels() {
        return orgVirtualNodeUserRels;
    }

    public void setOrgVirtualNodeUserRels(List<OrgVirtualNodeUserRel> orgVirtualNodeUserRels) {
        this.orgVirtualNodeUserRels = orgVirtualNodeUserRels;
    }
}
