package com.xforceplus.extenddao.impl;

import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.dto.resource.ServiceApiRouterDTO;
import com.xforceplus.entity.Tenant;
import com.xforceplus.extenddao.TenantExtendDao;
import org.springframework.stereotype.Repository;

import java.util.List;
import org.springframework.util.Assert;

@Repository
@SuppressWarnings("all")
public class TenantExtendDaoImpl extends AbstractDefaultJpaRepositoryImpl implements TenantExtendDao {

    @Override
    public List<Tenant> listTenantIdByAccountId(Long accountId) {
        StringQuery query = StringQuery.builder()
                .query("  select distinct tenant_id from sys_user where 1=1 ")
                .predicateNotNull(accountId).query(" and account_id =:accountId ")
                .param("accountId",accountId)
                .query(" and status = 1").build();
        return this.findBySql(query, Tenant.class, Boolean.TRUE);
    }

    @Override
    public List<Tenant> listTenantByIds(List<Long> tenantIdList) {
        StringQuery query = StringQuery.builder()
                .query("  SELECT tenant_id,\n" +
                        "    tenant_name,\n" +
                        "    tenant_code,\n" +
                        "    tenant_desc,\n" +
                        "    status,\n" +
                        "    tenant_logo\n " +
                        " FROM bss_tenant where 1=1 ")
                .predicateNotEmpty(tenantIdList).query(" and tenant_id in (:tenantIdList) ")
                .param("tenantIdList",tenantIdList)
                .query(" and status = 1").build();
        return this.findBySql(query, Tenant.class, Boolean.TRUE);
    }


    @Override
    public List<Tenant> listTenantByAccountId(Long accountId){
        Assert.notNull(accountId, "accountId为空！");
        StringQuery query = StringQuery.builder()
                .query(" select * \n" +
                        "    from\n" +
                        "        bss_tenant  bt\n" +
                        "  where tenant_id in (\n" +
                        "  select distinct tenant_id from sys_user where \n" +
                        "        account_id=:accountId \n" +
                        "        and status=1 \n" +
                        "        )\n" +
                        "        and bt.status=1 \n" +
                        "   ") .param("accountId", accountId)
                .build();

        return this.findBySql(query, Tenant.class, Boolean.TRUE);
    }

}
