package com.xforceplus.jpa.listener;


import com.xforceplus.entity.SsoConf;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;


/**
 * sso conf 自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class SsoConfListener {

    @PrePersist
    protected void beforeInsert(SsoConf entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreateUserId(String.valueOf(authorizedUser.getId()));
            entity.setCreateTime(new Date());
            if(authorizedUser.getOperaterName() != null) {
                entity.setUpdateUserName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdateUserName(StringUtils.EMPTY);
            }
        }
    }

    @PreUpdate
    protected void beforeUpdate(SsoConf entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdateUserId(String.valueOf(authorizedUser.getId()));
            entity.setUpdateTime(new Date());
            if(authorizedUser.getOperaterName() != null) {
                entity.setUpdateUserName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdateUserName(StringUtils.EMPTY);
            }
        }
    }
}