package com.xforceplus.jpa.listener;


import com.xforceplus.entity.TenantPolicy;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.utils.uuid.UUID;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;


/**
 * 租户策略 自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class TenantPolicyListener {
    @PrePersist
    public void prePersist(TenantPolicy entity) {
        if (entity.getName() == null) {
            entity.setName(UUID.randomUUID().toString());
        }

        this.beforeSave(entity);
    }

    @PreUpdate
    public void preUpdate(TenantPolicy entity) {
        this.beforeSave(entity);
    }

    private void beforeSave(TenantPolicy entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            entity.setUpdaterName(authorizedUser.getOperaterName());
            entity.setUpdateTime(Calendar.getInstance().getTime());
        }
    }
}