package com.xforceplus.query;


import com.xforceplus.api.model.AccountPlatformRelModel.Request.Query;
import com.xforceplus.entity.AccountPlatformRel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class AccountPlatformRelQueryHelper {

    public static Specification<AccountPlatformRel> querySpecification(Query query) {
        Specification<AccountPlatformRel> specification = (Specification<AccountPlatformRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (StringUtils.isNotBlank(query.getUserId())) {
                predicates.add(builder.equal(root.<String>get("userId"), query.getUserId()));
            }
            if (query.getAccountId() != null && query.getAccountId() > 0) {
                predicates.add(builder.equal(root.<Long>get("accountId"), query.getAccountId()));
            }
            if (query.getPlatformType() != null) {
                predicates.add(builder.equal(root.<String>get("platformType"), query.getPlatformType()));
            }
            if (StringUtils.isNotBlank(query.getPlatformId())) {
                predicates.add(builder.equal(root.<String>get("platformId"), query.getPlatformId()));
            }

            if (StringUtils.isNotBlank(query.getAppType())) {
                predicates.add(builder.equal(root.<String>get("appType"), query.getAppType()));
            }

            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }


}
