package com.xforceplus.query;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import javax.persistence.criteria.CriteriaBuilder.In;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class CompanyQueryHelper {
    public static Specification<Company> querySpecification(CompanyModel.Request.Query query) {
        Specification<Company> specification = (Specification<Company>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getTenantId() != null && query.getTenantId() > 0) || StringUtils.isNotBlank(query.getTenantName())) {
                ListJoin<Company, OrgStruct> joinOrg = root.joinList("orgs", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0) {
                    predicates.add(builder.equal(joinOrg.<Long>get("tenantId"), query.getTenantId()));
                }
                if (StringUtils.isNotBlank(query.getTenantName())) {
                    Join<OrgStruct, Tenant> joinTenant = joinOrg.join("tenant", JoinType.LEFT);
                    predicates.add(builder.like(joinTenant.get("tenantName"), query.getTenantName() + "%"));
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinTenant.get("status"), 1));
                    }
                }
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal(joinOrg.get("status"), 1));
                }
                joinTable = true;
            }
            if (StringUtils.isNotBlank(query.getCompanyCode())) {
                predicates.add(builder.equal(root.<String>get("companyCode"), query.getCompanyCode()));
            }
            if (StringUtils.isNotBlank(query.getTaxNum())) {
                predicates.add(builder.equal(root.<String>get("taxNum"), query.getTaxNum()));
            }
            if (StringUtils.isNotBlank(query.getCompanyName())) {
                predicates.add(builder.like(root.get("companyName"), query.getCompanyName() + "%"));
            }
            if (ArrayUtils.isNotEmpty(query.getCompanyCodes())) {
                In<String> in = builder.in(root.get("companyCode"));
                for (String code : query.getCompanyCodes()) {
                    in.value(code);
                }
                predicates.add(in);
            }
            //添加CompanyIds 导出功能
            if (ArrayUtils.isNotEmpty(query.getCompanyIds())) {
                In<Long> in = builder.in(root.get("companyId"));
                for (Long code :query.getCompanyIds()) {
                    in.value(code);
                }
                predicates.add(in);
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get("companyId"), query.getCompanyId()));
            }
            if (query.getInspectionServiceFlag() != null && query.getInspectionServiceFlag() > 0) {
                predicates.add(builder.equal(root.<Integer>get("inspectionServiceFlag"), query.getInspectionServiceFlag()));
            }
            if (query.getSpeedInspectionChannelFlag() != null && query.getSpeedInspectionChannelFlag() > 0) {
                predicates.add(builder.equal(root.<Integer>get("speedInspectionChannelFlag"), query.getSpeedInspectionChannelFlag()));
            }
            if (query.getTraditionAuthenFlag() != null && query.getTraditionAuthenFlag() > 0) {
                predicates.add(builder.equal(root.<Integer>get("traditionAuthenFlag"), query.getTraditionAuthenFlag()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("companyId"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

    public static Specification<Company> queryOneSpecification(CompanyModel.Request.Query query) {
        Specification<Company> specification = (Specification<Company>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if ((query.getTenantId() != null && query.getTenantId() > 0) || StringUtils.isNotBlank(query.getTenantName())) {
                ListJoin<Company, OrgStruct> joinOrg = root.joinList("orgs", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0) {
                    predicates.add(builder.equal(joinOrg.<Long>get("tenantId"), query.getTenantId()));
                }
                if (StringUtils.isNotBlank(query.getTenantName())) {
                    Join<OrgStruct, Tenant> joinTenant = joinOrg.join("tenant", JoinType.LEFT);
                    predicates.add(builder.equal(joinTenant.<String>get("tenantName"), query.getTenantName()));
                }

                criteriaQuery.groupBy(root.<Long>get("companyId"));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get("companyId"), query.getCompanyId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getTaxNum()) || StringUtils.isNotBlank(query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get("companyCode"), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get("taxNum"), query.getTaxNum()));
                }
                //region TODO delete it
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get("companyName"), query.getCompanyName()));
                }
                //endregion
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("查询参数不合法");
            } else {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
