package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualNodeTypeModel;
import com.xforceplus.entity.OrgVirtualNodeType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/22 11:14
 * 功能描述:
 * 修改历史:
 */
@SuppressWarnings("all")
public class OrgVirtualTypeQueryHelper {
    public static Specification<OrgVirtualNodeType> querySpecification(OrgVirtualNodeTypeModel.Request.Query query) {
        Specification<OrgVirtualNodeType> specification = (Specification<OrgVirtualNodeType>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (StringUtils.isNotBlank(query.getTypeName())) {
                predicates.add(builder.like(root.<String>get("typeName"), query.getTypeName() + "%"));
            }
            if (StringUtils.isNotBlank(query.getTypeCode())) {
                predicates.add(builder.like(root.<String>get("typeCode"), query.getTypeCode() + "%"));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
