package com.xforceplus.query;

import com.xforceplus.api.model.SettleTemplateModel;
import com.xforceplus.entity.SettleTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class SettleTemplateQueryHelper {
    public static Specification<SettleTemplate> querySpecification(SettleTemplateModel.Request.Query query) {
        Specification<SettleTemplate> specification = (Specification<SettleTemplate>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getFlowId() != null && query.getFlowId() > 0) {
                predicates.add(builder.equal(root.<Long>get("flowId"), query.getFlowId()));
                if (query.getPageIndex() != null && query.getPageIndex() > 0) {
                    predicates.add(builder.equal(root.<Integer>get("pageIndex"), query.getPageIndex()));
                }
            }
            if (query.getTemplateId() != null && query.getTemplateId() > 0) {
                predicates.add(builder.equal(root.<Long>get("templateId"), query.getTemplateId()));
            }
            if (StringUtils.isNotBlank(query.getTemplateName())) {
                predicates.add(builder.equal(root.<String>get("templateName"), query.getTemplateName()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
