package com.xforceplus.query;

import com.xforceplus.api.model.TenantPolicyModel;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantPolicy;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class TenantPolicyQueryHelper {
    public static Specification<TenantPolicy> querySpecification(TenantPolicyModel.Request.Query query) {
        Specification<TenantPolicy> specification = (Specification<TenantPolicy>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            Join<TenantPolicy, Tenant> joinTenant = root.join("tenant", JoinType.LEFT);
            if (!StringUtils.isEmpty(query.getTenantCode())) {
                predicates.add(builder.equal(joinTenant.<String>get("tenantCode"), query.getTenantCode()));
            }
            if (!StringUtils.isEmpty(query.getTenantNameEqual())) {
                predicates.add(builder.equal(joinTenant.<String>get("tenantName"), query.getTenantNameEqual()));
            }
            if (!StringUtils.isEmpty(query.getTenantName())) {
                predicates.add(builder.like(joinTenant.<String>get("tenantName"), "%" + query.getTenantName() + "%"));
            }
            if (!StringUtils.isEmpty(query.getTenantId())) {
                predicates.add(builder.equal(root.<String>get("tenantId"), query.getTenantId()));
            }
            if (!StringUtils.isEmpty(query.getName())) {
                predicates.add(builder.equal(root.<String>get("name"), query.getName()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
