/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.common;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DateUtils {
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final int PATTERN_CACHE_SIZE = 500;

    public static String format(Date date, String pattern) {
        return DateUtils.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), pattern);
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateUtils.createCacheFormatter(pattern);
        return localDateTime.format(formatter);
    }

    public static Date parseDate(String time, String pattern) {
        return Date.from(DateUtils.parseLocalDateTime(time, pattern).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getDateByDayEnd(Date date) {
        if (null == date) {
            return null;
        }
        return DateUtils.parseDate(DateUtils.format(date, "yyyy-MM-dd") + " " + "24:00:00", "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDateByDayBegin(Date date) {
        if (null == date) {
            return null;
        }
        return DateUtils.parseDate(DateUtils.format(date, "yyyy-MM-dd") + " " + "00:00:00", "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDateTime parseLocalDateTime(String time, String pattern) {
        DateTimeFormatter formatter = DateUtils.createCacheFormatter(pattern);
        return LocalDateTime.parse(time, formatter);
    }

    private static DateTimeFormatter createCacheFormatter(String pattern) {
        DateTimeFormatter oldFormatter;
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter formatter = (DateTimeFormatter)FORMATTER_CACHE.get(pattern);
        if (formatter == null && FORMATTER_CACHE.size() < 500 && (oldFormatter = FORMATTER_CACHE.putIfAbsent(pattern, formatter = DateTimeFormatter.ofPattern(pattern))) != null) {
            formatter = oldFormatter;
        }
        return formatter;
    }

    public static long getCustomTime(int hour, int minute, int second) {
        Calendar time = Calendar.getInstance();
        time.set(11, hour);
        time.set(12, minute);
        time.set(13, second);
        time.set(14, 0);
        return time.getTimeInMillis();
    }
}

