/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";
    public static final String ENTITY_NAME_NOT_BE_NULL = "Entity name must not be null or empty!";
    public static final String QUERY_NOT_BE_NULL = "Query  must not be null!";
    public static final String QUERY_HAS_TEXT = "Query must has text!";
    public static final String STRING_QUERY_HAS_TEXT = "Query must has text!";
    public static final String QUERY_COUNT_HAS_TEXT = "Query count must has text!";
    public static final String QUERY_PARAMS_NOT_BE_NULL = "QueryParams must not be null!";
    public static final String PAGEABLE_NOT_BE_NULL = "PageRequest must not be null!";
    public static final String TRANSFORMER_CLASS_MUST_NOT_BE_NULL = "Transformer Class must not be null";
    public static Pattern PATTERN_ORDER_BY = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
    public static final String WHERE_INVALID_CONDITION_WITH_AND = "(where)\\s*(1\\s*=\\s*1)\\s*(and)";
    public static final Pattern PATTERN_WHERE_INVALID_CONDITION_WITH_AND = Pattern.compile("(where)\\s*(1\\s*=\\s*1)\\s*(and)", 2);
    public static final String WHERE_INVALID_CONDITION = "(where)\\s*(1\\s*=\\s*1)";
    public static final Pattern PATTERN_WHERE_INVALID_CONDITION = Pattern.compile("(where)\\s*(1\\s*=\\s*1)", 2);
    public static final String CRLF = "(\\r\\n|\\r|\\n|\\n\\r)";
    public static final String ORDER_BY_SQL = " order by ";
    public static final String FETCH = " fetch";
    public static final String FROM = "from";
    public static final String WHERE = "where";

    public static String getQueryString(String template, String entityName) {
        Assert.hasText((String)entityName, (String)ENTITY_NAME_NOT_BE_NULL);
        return String.format(template, entityName);
    }

    public static String getCountQueryString(String entityName) {
        String countQuery = String.format(COUNT_QUERY_STRING, "x", "%s");
        return QueryUtils.getQueryString(countQuery, entityName);
    }

    public static String genCountQueryString(String queryString) {
        return "select count(*) " + QueryUtils.removeSelect(queryString);
    }

    public static String removeSelect(String queryString) {
        Assert.hasText((String)queryString, (String)QUERY_NOT_BE_NULL);
        queryString = QueryUtils.removeFetch(queryString);
        queryString = QueryUtils.removeOrders(queryString);
        int beginPos = queryString.toLowerCase().indexOf(FROM);
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" the jpql : " + queryString + " must has a keyword 'from'"));
        return queryString.substring(beginPos);
    }

    public static String removeOrderBy(String queryString) {
        Assert.hasText((String)queryString, (String)QUERY_NOT_BE_NULL);
        queryString = QueryUtils.removeFetch(queryString);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PATTERN_ORDER_BY.matcher(queryString);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String removeOrders(String queryString) {
        Matcher matcher = PATTERN_ORDER_BY.matcher(queryString);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String removeWhereInvalidCondition(CharSequence query) {
        Assert.notNull((Object)query, (String)QUERY_NOT_BE_NULL);
        String queryStr = String.valueOf(query).replaceAll(CRLF, "");
        Matcher matcher = PATTERN_WHERE_INVALID_CONDITION_WITH_AND.matcher(queryStr);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, WHERE);
        }
        matcher.appendTail(buffer);
        matcher = PATTERN_WHERE_INVALID_CONDITION.matcher(buffer);
        StringBuffer bufferInvalid = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(bufferInvalid, "");
        }
        matcher.appendTail(bufferInvalid);
        return bufferInvalid.toString();
    }

    public static String removeFetch(String queryString) {
        Assert.hasText((String)queryString, (String)QUERY_NOT_BE_NULL);
        return StringUtils.delete((String)queryString, (String)FETCH);
    }
}

