/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.transform;

import com.xforceplus.data.transform.UnderlineToBeanUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyChainedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class UnderlineToBeanResultTransformer
extends AliasToBeanResultTransformer {
    private static final Logger log = LoggerFactory.getLogger(UnderlineToBeanResultTransformer.class);
    private static final String ERROR_RESULT_CLASS = "Could not instantiate resultClass:";
    private final Class<?> resultClass;
    private boolean isInitialized;
    private String[] aliases;
    private Setter[] setters;

    public <T> UnderlineToBeanResultTransformer(Class<T> resultClass) {
        super(resultClass);
        Assert.notNull(resultClass, (String)"resultClass cannot be null");
        this.isInitialized = false;
        this.resultClass = resultClass;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object result;
        try {
            if (!this.isInitialized) {
                this.initialize(aliases);
            } else {
                this.check(aliases);
            }
            result = this.resultClass.newInstance();
            for (int i = 0; i < aliases.length; ++i) {
                if (this.setters[i] == null) continue;
                Object value = tuple[i];
                Class<?>[] parameterTypes = this.setters[i].getMethod().getParameterTypes();
                Class<?> setterParameterType = parameterTypes[0];
                if (value != null) {
                    if (setterParameterType == Long.class) {
                        value = Long.valueOf(value.toString());
                    } else if (setterParameterType == BigDecimal.class) {
                        value = new BigDecimal(value.toString());
                    } else if (setterParameterType == Boolean.class) {
                        value = Boolean.valueOf(value.toString());
                    }
                }
                this.setters[i].set(result, value, null);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new HibernateException(ERROR_RESULT_CLASS + this.resultClass.getName());
        }
        return result;
    }

    private void initialize(String[] aliases) {
        PropertyAccessStrategyChainedImpl propertyAccessStrategy = new PropertyAccessStrategyChainedImpl(new PropertyAccessStrategy[]{PropertyAccessStrategyBasicImpl.INSTANCE, PropertyAccessStrategyFieldImpl.INSTANCE, PropertyAccessStrategyMapImpl.INSTANCE});
        this.aliases = new String[aliases.length];
        this.setters = new Setter[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias == null) continue;
            this.aliases[i] = alias;
            alias = UnderlineToBeanUtils.underlineToCamel(alias);
            try {
                this.setters[i] = propertyAccessStrategy.buildPropertyAccess(this.resultClass, alias).getSetter();
                continue;
            }
            catch (Exception e) {
                log.warn(this.resultClass + " property " + alias + " not found");
            }
        }
        this.isInitialized = true;
    }

    private void check(String[] aliases) {
        if (!Arrays.equals(aliases, this.aliases)) {
            String message = "aliases are different from what is cached; aliases=" + Arrays.asList(aliases) + "cached= " + Arrays.asList(this.aliases);
            throw new IllegalStateException(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UnderlineToBeanResultTransformer that = (UnderlineToBeanResultTransformer)((Object)o);
        if (!this.resultClass.equals(that.resultClass)) {
            return false;
        }
        return Arrays.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        int result = this.resultClass.hashCode();
        result = 31 * result + (this.aliases == null ? 0 : Arrays.hashCode(this.aliases));
        return result;
    }
}

