/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgCompanyRel;
import com.xforceplus.entity.OrgExtension;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.jpa.listener.OrgListener;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import io.geewit.core.jackson.view.View;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="Org.graph", attributeNodes={@NamedAttributeNode(value="company"), @NamedAttributeNode(value="tenant"), @NamedAttributeNode(value="companyNos")})})
@EntityListeners(value={OrgListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="sys_org_struct")
public class OrgStruct
extends OrgDto<OrgStruct, OrgExtension>
implements Serializable {
    @JsonIgnore
    public boolean builtParentIds;
    @JsonView(value={OrgView.OrgInfo.class})
    private Company company;
    @JsonView(value={OrgView.OrgInfo.class})
    private Tenant tenant;
    @JsonView(value={OrgView.OrgInfo.class})
    private List<ServicePackage> packages;
    @JsonIgnore
    private List<OrgUserRel> orgUserRels;
    @JsonIgnore
    private List<OrgCompanyRel> orgCompanyRels;

    @Id
    @Column(name="org_struct_id", nullable=false)
    public Long getOrgId() {
        return this.orgId;
    }

    @Basic
    @Column(name="tenant_id")
    public Long getTenantId() {
        return this.tenantId != null && this.tenantId > 0L ? this.tenantId : null;
    }

    @Basic
    @Column(name="company_id")
    public Long getCompanyId() {
        return this.companyId != null && this.companyId > 0L ? this.companyId : null;
    }

    @Basic
    @Column(name="org_code", nullable=false)
    public String getOrgCode() {
        return this.orgCode;
    }

    @Basic
    @Column(name="org_name", nullable=false)
    public String getOrgName() {
        return this.orgName;
    }

    @Basic
    @Column(name="parent_ids", nullable=false)
    public String getParentIds() {
        return this.parentIds;
    }

    @Basic
    @Column(name="parent_id")
    public Long getParentId() {
        return this.parentId != null && this.parentId > 0L ? this.parentId : null;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="org_type", nullable=false)
    public OrgType getOrgType() {
        return this.orgType;
    }

    @Basic
    @Column(name="org_desc", nullable=false)
    public String getOrgDesc() {
        return this.orgDesc;
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="audit_status")
    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    @Basic
    @Column(name="enabled_time")
    public Date getEnabledTime() {
        return this.enabledTime;
    }

    @Basic
    @Column(name="disabled_time")
    public Date getDisabledTime() {
        return this.disabledTime;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @JsonIgnore
    @Transient
    public List<OrgStruct> getChildren() {
        return this.children;
    }

    @JsonView(value={OrgView.OrgInfo.class})
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="sys_org_companyno", joinColumns={@JoinColumn(name="org_struct_id")})
    @Column(name="company_no", insertable=false, updatable=false)
    public Set<String> getCompanyNos() {
        return this.companyNos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tenant_id", referencedColumnName="tenant_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="company_id", referencedColumnName="company_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    @NotFound(action=NotFoundAction.IGNORE)
    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getCompanyName() {
        if (this.companyName == null) {
            this.companyName = this.company != null ? this.company.getCompanyName() : null;
        }
        return this.companyName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getParentName() {
        return this.parentName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getCompanyCode() {
        if (this.companyCode == null) {
            this.companyCode = this.company != null ? this.company.getCompanyCode() : null;
        }
        return this.companyCode;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTaxNum() {
        if (this.taxNum == null) {
            this.taxNum = this.company != null ? this.company.getTaxNum() : null;
        }
        return this.taxNum;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTenantName() {
        if (this.tenantName == null) {
            this.tenantName = this.tenant != null ? this.tenant.getTenantName() : null;
        }
        return this.tenantName;
    }

    @JsonView(value={View.List.class})
    @Transient
    public String getTenantCode() {
        if (this.tenantCode == null) {
            this.tenantCode = this.tenant != null ? this.tenant.getTenantCode() : null;
        }
        return this.tenantCode;
    }

    @JsonView(value={View.Info.class})
    @Transient
    public List<ServicePackage> getPackages() {
        return this.packages;
    }

    public void setPackages(List<ServicePackage> packages) {
        this.packages = packages;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="org")
    public List<OrgUserRel> getOrgUserRels() {
        return this.orgUserRels;
    }

    public void setOrgUserRels(List<OrgUserRel> orgUserRels) {
        this.orgUserRels = orgUserRels;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="org")
    public List<OrgCompanyRel> getOrgCompanyRels() {
        return this.orgCompanyRels;
    }

    public void setOrgCompanyRels(List<OrgCompanyRel> orgCompanyRels) {
        this.orgCompanyRels = orgCompanyRels;
    }

    @JsonView(value={View.class})
    @Transient
    public List<OrgStruct> getParentOrgs() {
        return this.parentOrgs;
    }

    public void addChild(OrgStruct child) {
        if (this.children == null) {
            this.children = Stream.of(child).collect(Collectors.toList());
        } else if (this.children.stream().filter(Objects::nonNull).map(OrgStruct::getOrgId).filter(Objects::nonNull).noneMatch(orgId -> orgId.equals(child.getOrgId()))) {
            this.children.add(child);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

