/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.OrgStruct;
import com.xforceplus.jpa.listener.OperatorListener;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.geewit.utils.uuid.UUIDUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class OrgListener
extends OperatorListener<OrgStruct>
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(OrgListener.class);
    private ApplicationContext applicationContext;

    @PrePersist
    public void prePersist(OrgStruct entity) {
        JdbcTemplate jdbcTemplate;
        Long codeCount;
        if (entity.getOrgId() == null) {
            long id = SnowflakeGenerator.id();
            entity.setOrgId(id);
        }
        if (entity.getParentId() == null || entity.getParentId() == 0L) {
            entity.setOrgType(OrgType.GROUP);
        }
        if (entity.getCompanyId() != null && entity.getCompanyId() > 0L) {
            entity.setOrgType(OrgType.COMPANY);
        }
        if (entity.getOrgType() == null) {
            entity.setOrgType(OrgType.NORMAL);
        }
        if (StringUtils.isEmpty((CharSequence)entity.getOrgCode())) {
            entity.setOrgCode(UUIDUtils.randomUUID().toUpperCase());
        }
        if ((codeCount = (Long)(jdbcTemplate = (JdbcTemplate)this.applicationContext.getBean(JdbcTemplate.class)).queryForObject("select count(o.org_struct_id) from sys_org_struct o where o.tenant_id = ? and o.org_code = ?", Long.class, new Object[]{entity.getTenantId(), entity.getOrgCode()})) > 0L) {
            throw new IllegalArgumentException("\u79df\u6237(" + entity.getTenantId() + ")\u4e0b\u5df2\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7code(" + entity.getOrgCode() + ")");
        }
        if (entity.getOrgDesc() == null) {
            entity.setOrgDesc(entity.getOrgName());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getAuditStatus() == null) {
            entity.setAuditStatus(1);
        }
        if (entity.getStatus() == 1) {
            entity.setEnabledTime(Calendar.getInstance().getTime());
        }
        this.preSave(entity);
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(OrgStruct entity) {
        this.preSave(entity);
        if (entity.getCompanyId() != null && entity.getCompanyId() > 0L) {
            entity.setOrgType(OrgType.COMPANY);
        }
        if (entity.getOrgType() == null) {
            entity.setOrgType(OrgType.NORMAL);
        }
        if (entity.getStatus() != null) {
            if (entity.getStatus() == 1) {
                entity.setEnabledTime(Calendar.getInstance().getTime());
            }
            if (entity.getStatus() == 0) {
                entity.setDisabledTime(Calendar.getInstance().getTime());
            }
        }
        super.beforeUpdate(entity);
    }

    private void preSave(OrgStruct entity) {
        if (entity.getCompanyId() == null) {
            entity.setCompanyId(0L);
        }
        if (entity.getParentId() == null) {
            entity.setParentId(0L);
        }
        this.buildParentIds(entity);
    }

    public void buildParentIds(OrgStruct entity) {
        if (!entity.builtParentIds) {
            StringBuilder builder;
            block7: {
                builder = new StringBuilder();
                if (entity.getParentId() != null && entity.getParentId() > 0L) {
                    try {
                        JdbcTemplate jdbcTemplate = (JdbcTemplate)this.applicationContext.getBean(JdbcTemplate.class);
                        List parentIdsList = jdbcTemplate.queryForList("select o.parent_ids from sys_org_struct o where o.org_struct_id = ?", String.class, new Object[]{entity.getParentId()});
                        if (CollectionUtils.isEmpty((Collection)parentIdsList)) break block7;
                        Optional parentIdsOptional = parentIdsList.stream().findAny();
                        if (parentIdsOptional.isPresent()) {
                            builder.append((String)parentIdsOptional.get());
                            break block7;
                        }
                        String message = "\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7parentId(" + entity.getParentId() + ")";
                        logger.warn(message);
                        throw new IllegalArgumentException(message);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (entity.getOrgId() != null) {
                builder.append(entity.getOrgId());
            }
            if (entity.getOrgType() != null) {
                builder.append(entity.getOrgType().separator());
            }
            entity.setParentIds(builder.toString());
            entity.builtParentIds = true;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

