/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.entity.Company;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class CompanyQueryHelper {
    public static Specification<Company> querySpecification(CompanyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            CriteriaBuilder.In in;
            ArrayList<Object> predicates = new ArrayList<Object>();
            boolean joinTable = false;
            if (query.getTenantId() != null && query.getTenantId() > 0L || StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                ListJoin joinOrg = root.joinList("orgs", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0L) {
                    predicates.add(builder.equal((Expression)joinOrg.get("tenantId"), (Object)query.getTenantId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                    Join joinTenant = joinOrg.join("tenant", JoinType.LEFT);
                    predicates.add(builder.like((Expression)joinTenant.get("tenantName"), query.getTenantName() + "%"));
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinTenant.get("status"), (Object)1));
                    }
                }
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinOrg.get("status"), (Object)1));
                }
                joinTable = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                predicates.add(builder.equal((Expression)root.get("companyCode"), (Object)query.getCompanyCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                predicates.add(builder.equal((Expression)root.get("taxNum"), (Object)query.getTaxNum()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                predicates.add(builder.like((Expression)root.get("companyName"), query.getCompanyName() + "%"));
            }
            if (ArrayUtils.isNotEmpty((Object[])query.getCompanyCodes())) {
                in = builder.in((Expression)root.get("companyCode"));
                for (String string : query.getCompanyCodes()) {
                    in.value((Object)string);
                }
                predicates.add(in);
            }
            if (ArrayUtils.isNotEmpty((Object[])query.getCompanyIds())) {
                in = builder.in((Expression)root.get("companyId"));
                for (Long l : query.getCompanyIds()) {
                    in.value((Object)l);
                }
                predicates.add(in);
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
            }
            if (query.getInspectionServiceFlag() != null && query.getInspectionServiceFlag() > 0) {
                predicates.add(builder.equal((Expression)root.get("inspectionServiceFlag"), (Object)query.getInspectionServiceFlag()));
            }
            if (query.getSpeedInspectionChannelFlag() != null && query.getSpeedInspectionChannelFlag() > 0) {
                predicates.add(builder.equal((Expression)root.get("speedInspectionChannelFlag"), (Object)query.getSpeedInspectionChannelFlag()));
            }
            if (query.getTraditionAuthenFlag() != null && query.getTraditionAuthenFlag() > 0) {
                predicates.add(builder.equal((Expression)root.get("traditionAuthenFlag"), (Object)query.getTraditionAuthenFlag()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("companyId")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Company> queryOneSpecification(CompanyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0L || StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                ListJoin joinOrg = root.joinList("orgs", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0L) {
                    predicates.add(builder.equal((Expression)joinOrg.get("tenantId"), (Object)query.getTenantId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                    Join joinTenant = joinOrg.join("tenant", JoinType.LEFT);
                    predicates.add(builder.equal((Expression)joinTenant.get("tenantName"), (Object)query.getTenantName()));
                }
                criteriaQuery.groupBy(new Expression[]{root.get("companyId")});
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("companyCode"), (Object)query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("taxNum"), (Object)query.getTaxNum()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("companyName"), (Object)query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

