/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.tenant.security.core.domain.OrgType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public class OrgQueryHelper {
    public static Specification<OrgStruct> querySpecification(OrgModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> OrgQueryHelper.toPredicate(query, (Root<OrgStruct>)root, criteriaQuery, builder);
        return specification;
    }

    public static Predicate queryTuplePredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return OrgQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    public static Predicate queryCountPredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return OrgQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        Class resultType = criteriaQuery.getResultType();
        boolean isCount = resultType.isAssignableFrom(Long.class);
        boolean joinTable = false;
        Join joinCompany = null;
        Join joinTenant = null;
        if (query.getUserId() != null && query.getUserId() > 0L || query.getAccountId() != null && query.getAccountId() > 0L) {
            ListJoin joinOrgUserRel = root.joinList("orgUserRels", JoinType.LEFT);
            if (query.getUserId() != null && query.getUserId() > 0L) {
                boolean withExtraPredicates = false;
                if (query.getUserBoundFront() != null && query.getUserBoundFront() != false || query.getUserUnBound() != null && query.getUserUnBound() != false || query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag().booleanValue()) {
                    joinOrgUserRel.on((Expression)builder.equal((Expression)joinOrgUserRel.get("userId"), (Object)query.getUserId()));
                    if (resultType.isAssignableFrom(Tuple.class)) {
                        joinCompany = root.join("company", JoinType.LEFT);
                        joinTenant = root.join("tenant", JoinType.LEFT);
                        if (query.getUserBoundFront() != null && query.getUserBoundFront().booleanValue() || query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag().booleanValue()) {
                            Expression countExpression = builder.count((Expression)joinOrgUserRel.get("id"));
                            if (query.getUserBoundFront() != null && query.getUserBoundFront().booleanValue()) {
                                criteriaQuery = criteriaQuery.multiselect(new Selection[]{root.alias("org"), joinCompany.alias("company"), joinTenant.alias("tenant")});
                                criteriaQuery.orderBy(new Order[]{builder.desc(countExpression)});
                            } else if (query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag().booleanValue()) {
                                criteriaQuery = criteriaQuery.multiselect(new Selection[]{root.alias("org"), joinCompany.alias("company"), joinTenant.alias("tenant"), countExpression.alias("userBound")});
                            }
                        }
                    }
                    if (query.getUserUnBound() != null && query.getUserUnBound().booleanValue()) {
                        predicates.add(builder.isNull((Expression)joinOrgUserRel.get("id")));
                    }
                    withExtraPredicates = true;
                }
                if (!withExtraPredicates) {
                    predicates.add(builder.equal((Expression)joinOrgUserRel.get("userId"), (Object)query.getUserId()));
                }
            }
            if (query.getAccountId() != null && query.getAccountId() > 0L) {
                Join joinUser = joinOrgUserRel.join("user", JoinType.LEFT);
                predicates.add(builder.equal((Expression)joinUser.get("accountId"), (Object)query.getAccountId()));
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinUser.get("status"), (Object)1));
                }
            }
            joinTable = true;
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyNo())) {
            SetJoin joinCompanyNo = root.joinSet("companyNos", JoinType.LEFT);
            if (query.getCompanyNo().contains(",")) {
                String[] companyNos = query.getCompanyNo().split(",");
                String[] in = builder.in((Expression)joinCompanyNo);
                String[] stringArray = companyNos;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String code = stringArray[i];
                    in.value((Object)code);
                }
                predicates.add(in);
            } else {
                predicates.add(builder.equal((Expression)joinCompanyNo, (Object)query.getCompanyNo()));
            }
            joinTable = true;
        }
        if (query.getOrgId() != null && query.getOrgId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("orgId"), (Object)query.getOrgId()));
        }
        if (query.getTenantId() != null && query.getTenantId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getTenantName()) || StringUtils.isNotBlank((CharSequence)query.getTenantNameEqual())) {
            if (joinTenant == null) {
                joinTenant = root.join("tenant", JoinType.LEFT);
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                predicates.add(builder.equal((Expression)joinTenant.get("tenantCode"), (Object)query.getTenantCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantNameEqual())) {
                predicates.add(builder.equal((Expression)joinTenant.get("tenantName"), (Object)query.getTenantNameEqual()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                predicates.add(builder.like((Expression)joinTenant.get("tenantName"), query.getTenantName() + "%"));
            }
        }
        if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getOrgCode())) {
            if (query.getOrgCode().contains(",")) {
                String[] orgCodes = query.getOrgCode().split(",");
                CriteriaBuilder.In in = builder.in((Expression)root.get("orgCode"));
                for (String code : orgCodes) {
                    in.value((Object)code);
                }
                predicates.add(in);
            } else {
                predicates.add(builder.equal((Expression)root.get("orgCode"), (Object)query.getOrgCode()));
            }
        }
        if (query.getOrgType() != null) {
            predicates.add(builder.equal((Expression)root.get("orgType"), (Object)query.getOrgType()));
        }
        if (query.getWithNoRootOrg() != null && query.getWithNoRootOrg().equals(Boolean.TRUE)) {
            predicates.add(builder.notEqual((Expression)root.get("orgType"), (Object)OrgType.GROUP));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getOrgNameEqual())) {
            predicates.add(builder.equal((Expression)root.get("orgName"), (Object)query.getOrgNameEqual()));
        } else if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
            if (query.getOrgName().contains(",")) {
                String[] names = query.getOrgName().split(",");
                CriteriaBuilder.In in = builder.in((Expression)root.get("orgName"));
                for (String name : names) {
                    in.value((Object)name);
                }
                predicates.add(in);
            } else {
                predicates.add(builder.like((Expression)root.get("orgName"), query.getOrgName() + "%"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getParentIds())) {
            predicates.add(builder.like((Expression)root.get("parentIds"), query.getParentIds() + "%"));
        }
        if (query.getStatus() != null) {
            predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
            if (joinCompany == null) {
                joinCompany = root.join("company", JoinType.LEFT);
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                predicates.add(builder.equal((Expression)joinCompany.get("companyCode"), (Object)query.getCompanyCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                predicates.add(builder.like((Expression)joinCompany.get("companyName"), query.getCompanyName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                if (query.getTaxNum().contains(",")) {
                    String[] taxNums = query.getTaxNum().split(",");
                    CriteriaBuilder.In in = builder.in((Expression)joinCompany.get("taxNum"));
                    for (String name : taxNums) {
                        in.value((Object)name);
                    }
                    predicates.add(in);
                } else {
                    predicates.add(builder.equal((Expression)joinCompany.get("taxNum"), (Object)query.getTaxNum()));
                }
            }
            if (query.getStatus() != null && query.getStatus() == 1) {
                predicates.add(builder.equal((Expression)joinCompany.get("status"), (Object)1));
            }
        }
        if (query.getRootOrg() != null && query.getRootOrg().booleanValue()) {
            predicates.add(builder.or((Expression)builder.isNull((Expression)root.get("parentId")), (Expression)builder.equal((Expression)root.get("parentId"), (Object)0)));
        } else if (query.getParentId() != null && query.getParentId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("parentId"), (Object)query.getParentId()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
            CriteriaBuilder.In in = builder.in((Expression)root.get("orgId"));
            for (Long id : query.getIds()) {
                in.value((Object)id);
            }
            predicates.add(in);
        }
        if (predicates.isEmpty()) {
            predicates.add(builder.equal((Expression)root.get("status"), (Object)1));
        }
        criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
        if (joinTable) {
            if (isCount) {
                criteriaQuery.distinct(true);
            } else {
                criteriaQuery.groupBy(new Expression[]{root.get("orgId")});
            }
        }
        Predicate predicate = criteriaQuery.getRestriction();
        return predicate;
    }

    public static Specification<OrgStruct> queryOneSpecification(OrgModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getOrgId() != null && query.getOrgId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("orgId"), (Object)query.getOrgId()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
                if (StringUtils.isNotBlank((CharSequence)query.getOrgCode()) || StringUtils.isNotBlank((CharSequence)query.getOrgName()) || query.getCompanyId() != null && query.getCompanyId() > 0L) {
                    if (StringUtils.isNotBlank((CharSequence)query.getOrgCode())) {
                        predicates.add(builder.equal((Expression)root.get("orgCode"), (Object)query.getOrgCode()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
                        predicates.add(builder.equal((Expression)root.get("orgName"), (Object)query.getOrgName()));
                    }
                    if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                        predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
                    }
                }
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

