/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.UserModel;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public class UserQueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserQueryHelper.class);

    public static Specification<User> querySpecification(UserModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            Subquery subquery;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getExcludeBoundOrgVirtualNode() != null && query.getExcludeBoundOrgVirtualNode().booleanValue() && query.getTenantId() != null && query.getTenantId() > 0L && query.getOrgVirtualNodeId() != null && query.getOrgVirtualNodeId() > 0L) {
                subquery = criteriaQuery.subquery(OrgVirtualNodeUserRel.class);
                Root relOrgVirtualTreeRoot = subquery.from(OrgVirtualNodeUserRel.class);
                subquery.select((Expression)relOrgVirtualTreeRoot);
                Predicate[] subPredicates = new Predicate[]{builder.equal((Expression)relOrgVirtualTreeRoot.get("orgVirtualNodeId"), (Object)query.getOrgVirtualNodeId()), builder.equal((Expression)root.get("id"), (Expression)relOrgVirtualTreeRoot.get("userId"))};
                subquery.where(subPredicates);
                predicates.add(builder.not((Expression)builder.exists(subquery)));
            } else if (query.getExcludeBoundCurrent() != null && query.getTenantId() != null && query.getTenantId() > 0L && query.getExcludeBoundCurrent().booleanValue() && query.getRoleId() != null && query.getRoleId() > 0L) {
                subquery = criteriaQuery.subquery(RoleUserRel.class);
                Root roleUserRel = subquery.from(RoleUserRel.class);
                subquery.select((Expression)roleUserRel);
                Predicate[] subPredicates = new Predicate[]{builder.equal((Expression)roleUserRel.get("roleId"), (Object)query.getRoleId()), builder.equal((Expression)root.get("id"), (Expression)roleUserRel.get("userId"))};
                subquery.where(subPredicates);
                predicates.add(builder.not((Expression)builder.exists(subquery)));
            } else if (query.getRoleId() != null && query.getRoleId() > 0L || StringUtils.isNotBlank((CharSequence)query.getRoleCode()) || StringUtils.isNotBlank((CharSequence)query.getRoleIds())) {
                ListJoin userJoinRoleUserRel = root.joinList("roleUserRels", JoinType.LEFT);
                if (query.getRoleId() != null && query.getRoleId() > 0L) {
                    predicates.add(builder.equal((Expression)userJoinRoleUserRel.get("roleId"), (Object)query.getRoleId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleIds())) {
                    ArrayList roleIds = new ArrayList();
                    Arrays.stream(StringUtils.split((String)query.getRoleIds(), (String)",")).forEach(id -> {
                        try {
                            Long parseLong = Long.parseLong(id);
                            roleIds.add(parseLong);
                        }
                        catch (NumberFormatException e) {
                            String message = e.getMessage() + ", id: " + id;
                            logger.warn(message);
                        }
                    });
                    if (!roleIds.isEmpty()) {
                        predicates.add(userJoinRoleUserRel.get("roleId").in(roleIds));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    Join joinRole = userJoinRoleUserRel.join("role", JoinType.LEFT);
                    predicates.add(builder.equal((Expression)joinRole.get("code"), (Object)query.getRoleCode()));
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinRole.get("status"), (Object)1));
                    }
                }
                joinTable = true;
            } else if (query.getOrgVirtualNodeId() != null && query.getOrgVirtualNodeId() > 0L) {
                ListJoin userJoinRoleOrgVirtualTreeRel = root.joinList("orgVirtualNodeUserRels", JoinType.LEFT);
                predicates.add(builder.equal((Expression)userJoinRoleOrgVirtualTreeRel.get("orgVirtualNodeId"), (Object)query.getOrgVirtualNodeId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAccountName())) {
                Join joinAccount = root.join("account", JoinType.LEFT);
                predicates.add(builder.or(new Predicate[]{builder.equal((Expression)joinAccount.get("username"), (Object)query.getAccountName()), builder.equal((Expression)joinAccount.get("telPhone"), (Object)query.getAccountName()), builder.equal((Expression)joinAccount.get("email"), (Object)query.getAccountName())}));
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinAccount.get("status"), (Object)1));
                }
                joinTable = true;
            }
            if (query.getUserId() != null && query.getUserId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("id"), (Object)query.getUserId()));
            } else if (query.getUserIds() != null && !CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                predicates.add(root.get("id").in(query.getUserIds()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserCode())) {
                predicates.add(builder.equal((Expression)root.get("userCode"), (Object)query.getUserCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserName())) {
                predicates.add(builder.equal((Expression)root.get("userName"), (Object)query.getUserName()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserNumber())) {
                predicates.add(builder.equal((Expression)root.get("userNumber"), (Object)query.getUserNumber()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserPhone())) {
                predicates.add(builder.equal((Expression)root.get("userPhone"), (Object)query.getUserPhone()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserEmailAddr())) {
                predicates.add(builder.equal((Expression)root.get("userEmailAddr"), (Object)query.getUserEmailAddr()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserOptions())) {
                predicates.add(builder.or(new Predicate[]{builder.like((Expression)root.get("userName"), query.getUserOptions() + "%"), builder.equal((Expression)root.get("userCode"), (Object)query.getUserOptions()), builder.equal((Expression)root.get("userNumber"), (Object)query.getUserOptions()), builder.equal((Expression)root.get("userPhone"), (Object)query.getUserOptions()), builder.equal((Expression)root.get("userEmailAddr"), (Object)query.getUserOptions())}));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                Join joinTenant = root.join("tenant", JoinType.LEFT);
                if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                    predicates.add(builder.equal((Expression)joinTenant.get("tenantCode"), (Object)query.getTenantCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                    predicates.add(builder.like((Expression)joinTenant.get("tenantName"), query.getTenantName() + "%"));
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (query.getAccountId() != null && query.getAccountId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("accountId"), (Object)query.getAccountId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("id")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<User> queryOneSpecification(UserModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getUserId() != null && query.getUserId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("id"), (Object)query.getUserId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserCode())) {
                predicates.add(builder.equal((Expression)root.get("userCode"), (Object)query.getUserCode()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

