/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceQueryBo.java   2020-10-20 11-22-19
 * Author: Evan
 */
package com.xforceplus.bo;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * Title: 功能集查询类
 * </p>
 * <p>
 * Description:功能集查询类
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-20 11-22-19
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class ResourceSetQueryBo {
    /**
     * 功能集ID数据组
     */
    private Long[] resourceSetIds;

    /**
     * 功能集ID
     */
    private String   resourceSetName;


    /**
     * 功能集ID
     */
    private String   resourceSetCode;

    /**
     * 功能集状态
     */
    private Integer status;

    /**
     * 应用ID
     */
    private Long appId;

    /***
     *  资源码名称
     */
    private String resourceName;
    /**
     * 资源码Code
     */
    private String resourceCode;

    /**
     *
     * @return
     */
    public List<Long> getResourceSetIds(){
        if(ArrayUtils.isEmpty(resourceSetIds)){
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.resourceSetIds);
    }
}
