package com.xforceplus.dao;

import com.xforceplus.entity.App;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface AppDao extends JpaRepository<App, Long>, JpaSpecificationExecutor<App> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from App a where a.appId = :appId")
    void deleteById(@Param("appId") Long id);
}
