package com.xforceplus.dao;

import com.xforceplus.entity.Company;
import com.xforceplus.entity.ServicePackage;
import io.geewit.data.jpa.envers.repository.EnversRevisionRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * @author : geewit
 * Date: 19-12-03
 */
@SuppressWarnings("all")
public interface CompanyDao extends JpaRepository<Company, Long>, JpaSpecificationExecutor<Company>, CustomizedCompanyDao, EnversRevisionRepository<Company, Long, String> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Company c where c.companyId = :companyId")
    void deleteById(@Param("companyId") Long id);

    @Override
    List<Company> findAll();

    @Query("select new com.xforceplus.entity.ServicePackage(sp.servicePackageId, sp.servicePackageName, sp.appId) from com.xforceplus.entity.CompanyServiceRel csr left join com.xforceplus.entity.ServicePackage sp on sp.servicePackageId = csr.servicePackageId where csr.companyId = :companyId")
    List<ServicePackage> findPackagesByCompanyId(@Param("companyId") long companyId);

    /***
     *
     * @param companyId
     * @param companyCode
     * @param taxNum
     * @return long
     */
    @Query("select count(c.companyId) from Company c where (c.companyCode = :companyCode or c.taxNum = :taxNum ) and c.companyId <> :companyId ")
    long validateExistCompany(@Param("companyId") long companyId, @Param("companyCode") String companyCode, @Param("taxNum") String taxNum);

    /**
     * 根据税号查询公司列表
     * @param taxNum 公司税号
     * @return  List<Company>
     */
    List<Company> findByTaxNum(@Param("taxNum")String taxNum);
    /**
     *  删除CompanyName校验
     *  判断（公司代码，税号、名称）是否已存在
     * @param companyCode 公司代码
     * @param taxNum 税号
     * @return Long 返回统计行数
     */
    @Query("select count(c.companyId) from Company c where (c.companyCode = :companyCode or c.taxNum = :taxNum ) ")
    long validateExistCompany(@Param("companyCode") String companyCode, @Param("taxNum") String taxNum);


    /**
     *  查询
     * @return List<Map<String, Object>>
     */
    @Query(value = "select o.tenant_id, o.company_id from sys_org_struct o LEFT JOIN (select rel.tenant_id, rel.company_id from bss_tenant_company_rel rel) as r ON o.tenant_id = r.tenant_id and o.company_id = r.company_id where r.tenant_id is null and r.company_id is null and o.tenant_id > 0 and o.company_id > 0  group by o.tenant_id, o.company_id", nativeQuery = true)
    List<Map<String, Object>> findFixingCompanies();

    @Query(value = "select count(ca.revision) from bss_company_audit ca where ca.company_name = :companyName and ca.tax_num = :taxNum and ca.is_effective = 1", nativeQuery = true)
    long countAuditByTaxNumAndCompanyName(@Param("taxNum")String taxNum, @Param("companyName")String companyName);

    @Query(value = "select count(ca.revision) from bss_company_audit ca where ca.company_name = :companyName and ca.tax_num = :taxNum and ca.effective_date <= :effectiveDate and ca.is_effective = 1", nativeQuery = true)
    long countAuditByTaxNumAndCompanyNameAndEffectiveDate(@Param("taxNum")String taxNum, @Param("companyName")String companyName, @Param("effectiveDate")Date effectiveDate);

    /**
     * 公司审计表更新
     * @param companyId  公司id
     * @param revision   版本号
     * @param effective  是否有效
     * @return
     */
    @Modifying(flushAutomatically = true)
    @Query(value = "update bss_company_audit ca set ca.is_effective = :effective where ca.company_id = :companyId and ca.revision = :revision", nativeQuery = true)
    int updateAuditEffective(@Param("companyId") long companyId, @Param("revision") long revision, @Param("effective") boolean effective);

    @Query(value = "select c.company_id from bss_company c where c.tax_num = :taxNum", nativeQuery = true)
    Optional<Long> findIdByTaxNum(@Param("taxNum") String taxNum);

    /**
     *
     * @param ids 公司
     * @return  List<Company> 公司列表
     */
    @Query("select c from Company c where c.companyId in (:ids)")
    List<Company> findByIds(@Param("ids") List<Long> ids);
}

