package com.xforceplus.dao;

import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.ServicePackage;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface CompanyServiceRelDao extends JpaRepository<CompanyServiceRel, Long>, JpaSpecificationExecutor<CompanyServiceRel>, JpaBatchRepository<CompanyServiceRel, Long> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyServiceRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Query("select csr.servicePackage from CompanyServiceRel csr where csr.companyId = :companyId and csr.status = 1 and csr.servicePackage.status = 1")
    List<ServicePackage> findByCompanyId(@Param("companyId") Long companyId);

    @Query("select csr.servicePackage from CompanyServiceRel csr where csr.tenantId = :tenantId and csr.status = 1 and csr.servicePackage.status = 1")
    List<ServicePackage> findByTenantId(@Param("tenantId") Long tenantId);

    @Query("select new org.apache.commons.lang3.tuple.MutablePair(csr.companyId, csr.servicePackage) from CompanyServiceRel csr where csr.tenantId = :tenantId and csr.status = 1 and csr.servicePackage.status = 1")
    List<MutablePair<Long, ServicePackage>> findPairsByTenantId(@Param("tenantId") Long tenantId);


    List<CompanyServiceRel> findCompanyServiceRelByTenantIdEqualsAndCompanyIdEquals(Long tenantId, Long companyId);

    @Modifying(flushAutomatically = true)
    @Query("update CompanyServiceRel rel set rel.status = :status, rel.operateReason = :reason where rel.tenantId = :tenantId and rel.companyId = :companyId")
    void updateStatus(@Param("tenantId") long tenantId, @Param("companyId") long companyId, @Param("status") int status, @Param("reason") String reason);

    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyServiceRel rel where rel.servicePackageId = :servicePackageId")
    void deleteByPackageId(@Param("servicePackageId") long servicePackageId);

    long countByServicePackageId(long servicePackageId);


    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyServiceRel rel where rel.servicePackageId = :servicePackageId and rel.tenantId = :tenantId")
    void deleteCompanyPackageByPackageIdAndTenantId(@Param("servicePackageId") long servicePackageId, @Param("tenantId") long tenantId);

    @Query(value = "select csr.* from bss_company_service_rel csr"
        + " left join bss_tenant t on csr.tenant_id = t.tenant_id"
        + " left join bss_company c on csr.company_id = c.company_id"
        + " left join bss_service_package sp on csr.service_package_id = sp.service_package_id"
        + " where t.tenant_code = :tenantCode"
        + " and c.tax_num = :taxNum"
        + " and sp.service_package_code = :packageCode",nativeQuery = true)
    List<CompanyServiceRel> findByTenantCodeAndTaxNumAndPackageCode(@Param("tenantCode")String tenantCode, @Param("taxNum")String taxNum, @Param("packageCode")String packageCode);

    @Modifying(flushAutomatically = true)
    @Query("update CompanyServiceRel rel set rel.tenantId = :tenantId where rel.id in (:companyPackageIds)")
    void batchUpdateTenant(@Param("companyPackageIds") List<Long> companyPackageIds, @Param("tenantId")Long tenantId);

    List<CompanyServiceRel> findCompanyServiceRelByTenantId(Long tenantId);
}