package com.xforceplus.dao;

import com.xforceplus.entity.OrgExtension;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author lengmz
 * @since 2020-04-17
 */
public interface OrgExtensionDao extends JpaRepository<OrgExtension, Long>, JpaSpecificationExecutor<OrgExtension>, JpaBatchRepository<OrgExtension, Long> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from OrgExtension oe where oe.orgExtensionId = :id")
    void deleteById(@Param("id") Long id);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgExtension extension where extension.orgStructId = :orgId")
    int deleteByOrgId(@Param("orgId") long orgId);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgExtension extension where extension.orgStructId = :orgId and extension.extensionKey = :key")
    int deleteByOrgIdAndKey(@Param("orgId") long orgId, @Param("key") String key);

    @Query("select extension from OrgExtension extension where extension.orgStructId = :orgId and extension.extensionKey = :extensionKey")
    List<OrgExtension> findByOrgIdAndKey(@Param("orgId") long orgStructId, @Param("extensionKey") String extensionKey);

    /**
     * 查询组织列表
     * @param orgIds 组织Id列表
     * @return  List<OrgCompanyRel>
     */
    @Query(" select r from OrgExtension r where r.orgStructId in(:orgIds) ")
    List<OrgExtension> findByOrgIds(@Param("orgIds") List<Long> orgIds);
}
