package com.xforceplus.dao;

import com.xforceplus.entity.OrgVirtualNode;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
public interface OrgVirtualNodeDao extends JpaRepository<OrgVirtualNode, Long>, JpaSpecificationExecutor<OrgVirtualNode>, CustomizedOrgVirtualNodeDao {


    List<OrgVirtualNode> findByTenantIdAndOrgVirtualId(Long tenantId, Long orgVirtualId);

    List<OrgVirtualNode> findByTenantIdAndParentId(Long tenantId, Long parentId);

    Optional<OrgVirtualNode> findByTenantIdAndNodeTypeIdAndParentIdIsNull(Long tenantId, Long typeId);

    Optional<OrgVirtualNode> findByNodeTypeIdAndOrgVirtualId(Long typeId, Long orgVirtualId);

    @Query(value = "select b.org_virtual_node_id from sys_org_virtual a " +
            "left join sys_org_virtual_node b " +
            "on a.org_virtual_id = b.org_virtual_id " +
            "where a.org_code=:orgCode and b.node_type_id=:typeId and a.tenant_id=:tenantId ", nativeQuery = true)
    Optional<Long> findByNodeTypeIdAndOrgCodeAndTenantId(@Param("tenantId") Long tenantId,@Param("typeId") Long typeId, @Param("orgCode") String orgCode);

    Optional<OrgVirtualNode> findByTenantIdAndOrgVirtualNodeId(Long tenantId, Long orgVirtualNodeId);
}
