package com.xforceplus.dao;

import com.xforceplus.entity.ResourceApiRel;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ResourceApiRelDao extends JpaRepository<ResourceApiRel, Long>, JpaSpecificationExecutor<ResourceApiRel>, JpaBatchRepository<ResourceApiRel, Long> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ResourceApiRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Override
    List<ResourceApiRel> findAll();

    long countByServiceApiId(long serviceApiId);

    List<ResourceApiRel> findByServiceApiId(Long serviceApiId);

    @Modifying(clearAutomatically = true)
    @Query("delete from ResourceApiRel rel where rel.serviceApiId = :serviceApiId and rel.resourceId = :resourceId")
    void deleteByServiceApiIdAndResourceId(@Param("serviceApiId") long serviceApiId, @Param("resourceId") long resourceId);

    @Modifying(clearAutomatically = true)
    @Query("delete from ResourceApiRel rel where rel.serviceApiId = :serviceApiId")
    void deleteByServiceApiId(@Param("serviceApiId") long serviceApiId);

    List<ResourceApiRel> findByResourceId(Long resourceId);
}
