package com.xforceplus.dao;

import com.xforceplus.entity.RoleResourcesetRel;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface RoleResourcesetRelDao extends JpaRepository<RoleResourcesetRel, Long>, JpaSpecificationExecutor<RoleResourcesetRel>, JpaBatchRepository<RoleResourcesetRel, Long> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from RoleResourcesetRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Override
    List<RoleResourcesetRel> findAll();

    List<RoleResourcesetRel> findByRoleId(long roleId);

    @Query("select r from RoleResourcesetRel r where r.roleId = :roleId and r.resousesetId =:resousesetId and r.tenantId=:tenantId")
    RoleResourcesetRel findByRoleIdAndResourcesetIdAndTenantId(@Param("roleId") long roleId, @Param("resousesetId") long resousesetId, @Param("tenantId") long tenantId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleResourcesetRel rel where rel.roleId = :roleId")
    void deleteByRoleId(@Param("roleId") long roleId);
}
