package com.xforceplus.dao;

import com.xforceplus.entity.SettleStep;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;
import java.util.Optional;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleStepDao extends JpaRepository<SettleStep, Long>, JpaSpecificationExecutor<SettleStep> {

    Optional<SettleStep> findByTaxNum(String taxNum);

    List<SettleStep> findByTaxNumAndFlowId(String taxNum, Long flowId);

    List<SettleStep> findByTenantId(Long tenantId);

    List<SettleStep> findByTaxNumAndTenantId(String taxNum, Long tenantId);
}
