package com.xforceplus.dao;

import com.xforceplus.entity.SettleTemplateServiceRel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleTemplateServiceRelDao extends JpaRepository<SettleTemplateServiceRel, Long>, JpaSpecificationExecutor<SettleTemplateServiceRel> {
    @Query("select rel.serviceId from SettleTemplateServiceRel rel where rel.templateId = :templateId")
    List<Long> findServiceIdByTemplateId(@Param("templateId") long templateId);

    @Modifying(flushAutomatically = true)
    @Query("delete from SettleTemplateServiceRel rel where rel.templateId = :templateId")
    void deleteByTemplateId(@Param("templateId") long templateId);
}
