package com.xforceplus.dao;

import com.xforceplus.entity.TenantExtension;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author lengmz
 * @since 2020-07-15
 */
public interface TenantExtensionDao extends JpaRepository<TenantExtension, Long>, JpaSpecificationExecutor<TenantExtension>, JpaBatchRepository<TenantExtension, Long> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from TenantExtension te where te.tenantExtensionId = :id")
    void deleteById(@Param("id") Long id);

    @Modifying(clearAutomatically = true)
    @Query("delete from TenantExtension tx where tx.tenantId = :tenantId")
    void deleteByTenantId(@Param("tenantId") long tenantId);

    @Query("select ext from TenantExtension ext where ext.tenantId = :tenantId and ext.extensionKey = :key")
    List<TenantExtension> findByTenantIdAndKey(@Param("tenantId") long tenantId, @Param("key") String extensionKey);
}
